/*
 * Decompiled with CFR 0.152.
 */
package com.sap.i18n.cp;

import com.sap.i18n.cp.ConvertArrException;
import com.sap.i18n.cp.ConvertBase;
import com.sap.i18n.cp.ConvertCCCDataErrInfo;
import com.sap.i18n.cp.ConvertSimpleBase;
import com.sap.i18n.cp.ConverterException;
import com.sap.i18n.cp.ConverterJNI;
import com.sap.tc.logging.Location;

public class ConvertXToC
extends ConvertSimpleBase {
    private static final Location m_oLoc = Location.getLocation("com.sap.i18n.cp.ConvertXToC");

    public ConvertXToC(char[] sInCp, boolean bIgnoreErr) {
        super(sInCp, ConvertBase.m_acUcCp, bIgnoreErr, false);
    }

    public ConvertXToC(char[] sInCp, boolean bIgnoreErr, boolean bFailOnErr) {
        super(sInCp, ConvertBase.m_acUcCp, bIgnoreErr, bFailOnErr);
    }

    public final String Convert(byte[] abIn) {
        if (this.isShortcut()) {
            char[] cOut = this.ConvertArr(abIn, 0, abIn.length);
            if (this.m_oCnvLastErr == null || this.m_bIgnoreErr) {
                return new String(cOut);
            }
            return null;
        }
        return this.ConvertViaJNI(abIn);
    }

    public final int ConvertArr(byte[] abIn, int nInBeginIndex, int nInEndIndex, char[] acOut, int nOutBeginIndex, int nOutEndIndex) {
        try {
            return this.ConvertArrImpl(abIn, nInBeginIndex, nInEndIndex, acOut, nOutBeginIndex, nOutEndIndex);
        }
        catch (ConvertArrException eCnvErr) {
            ConvertCCCDataErrInfo oErrInfo = eCnvErr.getInfo();
            this.m_oCnvLastErr = oErrInfo;
            return oErrInfo.m_sOutDone.length();
        }
    }

    public final int ConvertArrExc(byte[] abIn, int nInBeginIndex, int nInEndIndex, char[] acOut, int nOutBeginIndex, int nOutEndIndex) throws ConverterException {
        try {
            return this.ConvertArrImpl(abIn, nInBeginIndex, nInEndIndex, acOut, nOutBeginIndex, nOutEndIndex);
        }
        catch (ConvertArrException eCnvErr) {
            ConvertCCCDataErrInfo oErrInfo = eCnvErr.getInfo();
            this.m_oCnvLastErr = oErrInfo;
            if (this.m_bIgnoreErr) {
                return oErrInfo.m_sOutDone.length();
            }
            throw new ConverterException(oErrInfo.GetText());
        }
    }

    public int outLength(byte[] abIn, int nInBeginIndex, int nInEndIndex) {
        int nInLen = nInEndIndex - nInBeginIndex;
        byte[] abInTmp = new byte[nInLen];
        System.arraycopy(abIn, nInBeginIndex, abInTmp, 0, nInLen);
        String sOut = this.ConvertViaJNI(abInTmp);
        int nOutLen = sOut != null ? sOut.length() : 0;
        return nOutLen;
    }

    public char[] ConvertArr(byte[] abIn, int nInBeginIndex, int nInEndIndex) {
        if (this.isShortcut()) {
            int nOutLength = this.outLength(abIn, nInBeginIndex, nInEndIndex);
            char[] cOut = new char[nOutLength];
            this.ConvertArr(abIn, nInBeginIndex, nInEndIndex, cOut, 0, nOutLength);
            return cOut;
        }
        int nInLen = nInEndIndex - nInBeginIndex;
        byte[] abInTmp = new byte[nInLen];
        System.arraycopy(abIn, nInBeginIndex, abInTmp, 0, nInLen);
        String sOut = this.Convert(abInTmp);
        return sOut.toCharArray();
    }

    public boolean isConvertIgnoreErrThreadSafe() {
        return this.isShortcut();
    }

    protected int ConvertArrImpl(byte[] abIn, int nInBeginIndex, int nInEndIndex, char[] acOut, int nOutBeginIndex, int nOutEndIndex) throws ConvertArrException {
        int[] aRet = new int[]{0, 0};
        if (!this.m_bCnvObjInit) {
            ConvertXToC.throwConverterRuntimeException(m_oLoc, this.m_oCnvLastErr.GetText());
        }
        if (!m_bCnvArrAvailable) {
            return this.ConvertArrFallback(abIn, nInBeginIndex, nInEndIndex, acOut, nOutBeginIndex, nOutEndIndex);
        }
        int nDone = ConverterJNI.ConvertXToCArrR(this.m_aCnvObj, abIn, nInBeginIndex, nInEndIndex, acOut, nOutBeginIndex, nOutEndIndex, aRet);
        if (aRet[0] != 0) {
            ConvertCCCDataErrInfo oCnvErrInfo = this.createCnvErr("ConvertXToCArr", aRet[0], abIn, nInBeginIndex, nInEndIndex, aRet[1], acOut, nOutBeginIndex, nOutBeginIndex + nDone);
            if (aRet[0] != 32) {
                ConvertXToC.checkFatalReturn(m_oLoc, this.m_oCnvLastErr, this.m_bIgnoreErr);
            }
            throw new ConvertArrException(oCnvErrInfo);
        }
        return nDone;
    }

    protected final ConvertCCCDataErrInfo createCnvErr(String sAction, int nErr, byte[] abIn, int nInBeginIndex, int nInEndIndex, int nInPos, char[] acOut, int nOutBeginIndex, int nOutPos) {
        int nInLen = nInEndIndex - nInBeginIndex;
        byte[] abInTmp = new byte[nInLen];
        System.arraycopy(abIn, nInBeginIndex, abInTmp, 0, nInLen);
        int nOutLenDone = nOutPos - nOutBeginIndex;
        String sOut = new String(acOut, nOutBeginIndex, nOutLenDone);
        return new ConvertCCCDataErrInfo(sAction, this.m_sInCp, this.m_sOutCp, nErr, abInTmp, sOut, nInPos - nInBeginIndex);
    }

    final int GetSb2UcTab(char[] acTab) {
        int nRet = ConverterJNI.GetSb2UcTab(this.m_aCnvObj, acTab);
        this.checkShortcutLoaded(nRet);
        return nRet;
    }

    final int[] GetDb2UcTab(byte[] abLeadByte2LengthTab, char[] acLeadByte2ValueTab, char[] acBrokenDb2UcTab, int[] aRet) {
        int[] m_anDb2UcTab = ConverterJNI.GetDb2UcTab(this.m_aCnvObj, abLeadByte2LengthTab, acLeadByte2ValueTab, acBrokenDb2UcTab, aRet);
        this.checkShortcutLoaded(aRet[0]);
        return m_anDb2UcTab;
    }

    private int ConvertArrFallback(byte[] abIn, int nInBeginIndex, int nInEndIndex, char[] acOut, int nOutBeginIndex, int nOutEndIndex) {
        int nInLen = nInEndIndex - nInBeginIndex;
        int[] aRet = new int[]{0, 0};
        byte[] abInTmp = new byte[nInLen];
        System.arraycopy(abIn, nInBeginIndex, abInTmp, 0, nInLen);
        String sOutRet = ConverterJNI.ConvertXToC(this.m_aCnvObj, abInTmp, aRet);
        if (sOutRet == null) {
            return 0;
        }
        int nOutLen = nOutEndIndex - nOutBeginIndex;
        int nDone = nOutLen >= sOutRet.length() ? sOutRet.length() : nOutLen;
        sOutRet.getChars(0, nDone, acOut, nOutBeginIndex);
        return nDone;
    }

    private String ConvertViaJNI(byte[] abIn) {
        this.m_oCnvLastErr = null;
        int[] aRet = new int[]{0, 0};
        if (!this.m_bCnvObjInit) {
            ConvertXToC.throwConverterRuntimeException(m_oLoc, this.m_oCnvLastErr.GetText());
        }
        String sOut = ConverterJNI.ConvertXToC(this.m_aCnvObj, abIn, aRet);
        if (aRet[0] != 0) {
            this.m_oCnvLastErr = new ConvertCCCDataErrInfo("ConvertXToC", this.m_sInCp, this.m_sOutCp, aRet[0], abIn, sOut, aRet[1]);
            sOut = null;
            ConvertXToC.checkFatalReturn(m_oLoc, this.m_oCnvLastErr, this.m_bIgnoreErr);
        }
        return sOut;
    }
}

