/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Codecs {

    public static class MD5 {
        static final ThreadLocal<MessageDigest> messageDigestThreadLocal = new ThreadLocal<MessageDigest>(){

            @Override
            protected MessageDigest initialValue() {
                try {
                    return MessageDigest.getInstance("MD5");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new Error(e.toString(), e);
                }
            }
        };

        public static byte[] getMD5Hash(String string) {
            try {
                return messageDigestThreadLocal.get().digest(string.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new Error(e.toString(), e);
            }
        }

        public static String getMD5HashAsString(String string) {
            return Hex.encode(MD5.getMD5Hash(string));
        }
    }

    public static class Base64 {
        private static final byte[] fromBase64;
        private static final char[] toBase64;
        private static final char PAD_CHAR = '=';
        private static final char ESC_CHAR = '%';
        private static final int IIIIIIII = 255;
        private static final int OIIIIIII = 127;
        private static final int IIIIII00 = 252;
        private static final int OOOOOOII = 3;
        private static final int IIIIOOOO = 240;
        private static final int OOOOIIII = 15;
        private static final int IIOOOOOO = 192;
        private static final int OOIIIIII = 63;

        public static final byte[] decode(byte[] data) {
            if (data == null) {
                return new byte[0];
            }
            return Base64.decode(data, 0, data.length);
        }

        public static final byte[] decode(byte[] data, int offset, int length) {
            if (data == null || length <= 0 || offset < 0 || offset >= data.length) {
                return new byte[0];
            }
            length = Math.min(length, data.length - offset);
            int index = offset + length - 1;
            while (length > 0 && data[index] == 61) {
                --length;
                --index;
            }
            int resultLength = length / 4 * 3;
            switch (length % 4) {
                case 2: {
                    ++resultLength;
                    break;
                }
                case 3: {
                    resultLength += 2;
                    break;
                }
            }
            byte[] result = new byte[resultLength];
            int bits = 0;
            int count = 0;
            index = 0;
            while (length > 0) {
                int low;
                int high;
                byte value;
                if ((value = data[offset++]) == 37 && length > 2 && (high = Character.digit(data[offset], 16)) >= 0 && (low = Character.digit(data[offset + 1], 16)) >= 0) {
                    value = (byte)(high << 4 | low);
                    offset += 2;
                    length -= 2;
                }
                if (value >= 0 && (value = fromBase64[value]) >= 0) {
                    bits = bits << 6 | value;
                    if ((count += 6) >= 8) {
                        result[index++] = (byte)(bits >>> (count -= 8) & 0xFF);
                    }
                }
                --length;
            }
            if (index < resultLength) {
                byte[] newResult = new byte[index];
                System.arraycopy(result, 0, newResult, 0, index);
                return newResult;
            }
            return result;
        }

        public static final byte[] decode(char[] data) {
            if (data == null) {
                return new byte[0];
            }
            return Base64.decode(data, 0, data.length);
        }

        public static final byte[] decode(char[] data, int offset, int length) {
            if (data == null || length <= 0 || offset < 0 || offset >= data.length) {
                return new byte[0];
            }
            length = Math.min(length, data.length - offset);
            int index = offset + length - 1;
            while (length > 0 && data[index] == '=') {
                --length;
                --index;
            }
            int resultLength = length / 4 * 3;
            switch (length % 4) {
                case 2: {
                    ++resultLength;
                    break;
                }
                case 3: {
                    resultLength += 2;
                    break;
                }
            }
            byte[] result = new byte[resultLength];
            int bits = 0;
            int count = 0;
            index = 0;
            while (length > 0) {
                byte value;
                int low;
                int high;
                char input;
                if ((input = data[offset++]) == '%' && length > 2 && (high = Character.digit(data[offset], 16)) >= 0 && (low = Character.digit(data[offset + 1], 16)) >= 0) {
                    input = (char)(high << 4 | low);
                    offset += 2;
                    length -= 2;
                }
                if (input <= '\u007f' && (value = fromBase64[input]) >= 0) {
                    bits = bits << 6 | value;
                    if ((count += 6) >= 8) {
                        result[index++] = (byte)(bits >>> (count -= 8) & 0xFF);
                    }
                }
                --length;
            }
            if (index < resultLength) {
                byte[] newResult = new byte[index];
                System.arraycopy(result, 0, newResult, 0, index);
                return newResult;
            }
            return result;
        }

        public static final byte[] decode(CharSequence data) {
            if (data == null) {
                return new byte[0];
            }
            return Base64.decode(data, 0, data.length());
        }

        public static final byte[] decode(CharSequence data, int start) {
            if (data == null) {
                return new byte[0];
            }
            return Base64.decode(data, start, data.length());
        }

        public static final byte[] decode(CharSequence data, int start, int end) {
            if (data == null || start < 0 || start > end || start >= data.length()) {
                return new byte[0];
            }
            end = Math.min(end, data.length());
            int length = end - start;
            int index = end - 1;
            while (length > 0 && data.charAt(index) == '=') {
                --length;
                --index;
            }
            int resultLength = length / 4 * 3;
            switch (length % 4) {
                case 2: {
                    ++resultLength;
                    break;
                }
                case 3: {
                    resultLength += 2;
                    break;
                }
            }
            byte[] result = new byte[resultLength];
            int bits = 0;
            int count = 0;
            index = 0;
            while (length > 0) {
                byte value;
                int low;
                int high;
                char input;
                if ((input = data.charAt(start++)) == '%' && length > 2 && (high = Character.digit(data.charAt(start), 16)) >= 0 && (low = Character.digit(data.charAt(start + 1), 16)) >= 0) {
                    input = (char)(high << 4 | low);
                    start += 2;
                    length -= 2;
                }
                if (input <= '\u007f' && (value = fromBase64[input]) >= 0) {
                    bits = bits << 6 | value;
                    if ((count += 6) >= 8) {
                        result[index++] = (byte)(bits >>> (count -= 8) & 0xFF);
                    }
                }
                --length;
            }
            if (index < resultLength) {
                byte[] newResult = new byte[index];
                System.arraycopy(result, 0, newResult, 0, index);
                return newResult;
            }
            return result;
        }

        public static final String encode(byte[] data) {
            if (data == null) {
                return new String();
            }
            return new String(Base64.encodeAsCharArray(data, 0, data.length));
        }

        public static final String encode(byte[] data, int offset, int length) {
            return new String(Base64.encodeAsCharArray(data, offset, length));
        }

        public static final byte[] encodeAsByteArray(byte[] data) {
            if (data == null) {
                return new byte[0];
            }
            return Base64.encodeAsByteArray(data, 0, data.length);
        }

        public static final byte[] encodeAsByteArray(byte[] data, int offset, int length) {
            byte b;
            byte a;
            if (data == null || length <= 0 || offset < 0 || offset >= data.length) {
                return new byte[0];
            }
            byte[] result = new byte[(length + 2) / 3 * 4];
            int index = 0;
            for (length = Math.min(length, data.length - offset); length > 2; length -= 3) {
                a = data[offset++];
                b = data[offset++];
                byte c = data[offset++];
                result[index++] = (byte)toBase64[(a & 0xFC) >> 2];
                result[index++] = (byte)toBase64[(a & 3) << 4 | (b & 0xF0) >> 4];
                result[index++] = (byte)toBase64[(b & 0xF) << 2 | (c & 0xC0) >> 6];
                result[index++] = (byte)toBase64[c & 0x3F];
            }
            switch (length) {
                case 1: {
                    a = data[offset];
                    result[index++] = (byte)toBase64[(a & 0xFC) >> 2];
                    result[index++] = (byte)toBase64[(a & 3) << 4];
                    result[index++] = 61;
                    result[index] = 61;
                    break;
                }
                case 2: {
                    a = data[offset++];
                    b = data[offset];
                    result[index++] = (byte)toBase64[(a & 0xFC) >> 2];
                    result[index++] = (byte)toBase64[(a & 3) << 4 | (b & 0xF0) >> 4];
                    result[index++] = (byte)toBase64[(b & 0xF) << 2];
                    result[index] = 61;
                    break;
                }
            }
            return result;
        }

        public static final char[] encodeAsCharArray(byte[] data) {
            if (data == null) {
                return new char[0];
            }
            return Base64.encodeAsCharArray(data, 0, data.length);
        }

        public static final char[] encodeAsCharArray(byte[] data, int offset, int length) {
            byte b;
            byte a;
            if (data == null || length <= 0 || offset < 0 || offset >= data.length) {
                return new char[0];
            }
            char[] result = new char[(length + 2) / 3 * 4];
            int index = 0;
            for (length = Math.min(length, data.length - offset); length > 2; length -= 3) {
                a = data[offset++];
                b = data[offset++];
                byte c = data[offset++];
                result[index++] = toBase64[(a & 0xFC) >> 2];
                result[index++] = toBase64[(a & 3) << 4 | (b & 0xF0) >> 4];
                result[index++] = toBase64[(b & 0xF) << 2 | (c & 0xC0) >> 6];
                result[index++] = toBase64[c & 0x3F];
            }
            switch (length) {
                case 1: {
                    a = data[offset];
                    result[index++] = toBase64[(a & 0xFC) >> 2];
                    result[index++] = toBase64[(a & 3) << 4];
                    result[index++] = 61;
                    result[index] = 61;
                    break;
                }
                case 2: {
                    a = data[offset++];
                    b = data[offset];
                    result[index++] = toBase64[(a & 0xFC) >> 2];
                    result[index++] = toBase64[(a & 3) << 4 | (b & 0xF0) >> 4];
                    result[index++] = toBase64[(b & 0xF) << 2];
                    result[index] = 61;
                    break;
                }
            }
            return result;
        }

        static {
            int i;
            fromBase64 = new byte[128];
            toBase64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
            for (i = 127; i >= 0; --i) {
                Base64.fromBase64[i] = -1;
            }
            for (i = 63; i >= 0; --i) {
                Base64.fromBase64[Base64.toBase64[i]] = (byte)i;
            }
            Base64.fromBase64[33] = fromBase64[43];
        }
    }

    public static class Hex {
        public static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

        public static final String encode(byte[] value) {
            if (value == null) {
                return "";
            }
            char[] s = new char[value.length * 2];
            int k = 0;
            for (int i = 0; i < value.length; ++i) {
                s[k++] = HEX[value[i] >> 4 & 0xF];
                s[k++] = HEX[value[i] & 0xF];
            }
            return new String(s);
        }

        public static final String encode(byte value) {
            char[] s = new char[]{HEX[value >> 4 & 0xF], HEX[value & 0xF]};
            return new String(s);
        }

        public static final String encode(char value) {
            char[] s = new char[]{HEX[value >> 12 & 0xF], HEX[value >> 8 & 0xF], HEX[value >> 4 & 0xF], HEX[value & 0xF]};
            return new String(s);
        }

        public static final String encode(int value) {
            char[] s = new char[]{HEX[value >> 28 & 0xF], HEX[value >> 24 & 0xF], HEX[value >> 20 & 0xF], HEX[value >> 16 & 0xF], HEX[value >> 12 & 0xF], HEX[value >> 8 & 0xF], HEX[value >> 4 & 0xF], HEX[value & 0xF]};
            return new String(s);
        }

        public static final byte[] decode(String value) {
            if (value == null) {
                return new byte[0];
            }
            char[] chars = value.toCharArray();
            return Hex.decode(chars, 0, chars.length);
        }

        public static final byte[] decode(char[] chars, int offset, int length) {
            if (chars == null) {
                return new byte[0];
            }
            byte[] buf = new byte[(length + 1) / 2];
            for (int i = 0; i < length; ++i) {
                byte d = (byte)Character.digit(chars[offset + i], 16);
                int n = i >> 1;
                buf[n] = (byte)(buf[n] | d << (1 - (i & 1) << 2));
            }
            return buf;
        }

        public static final int decode(char high, char low) {
            return Character.digit(high, 16) << 4 | Character.digit(low, 16);
        }
    }
}

