/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.timer.modular.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.cron.CronUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.hutool.http.HtmlUtil;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.entity.BaseEntity;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.timer.api.TimerAction;
import cn.stylefeng.roses.kernel.timer.api.TimerExeService;
import cn.stylefeng.roses.kernel.timer.api.enums.TimerJobStatusEnum;
import cn.stylefeng.roses.kernel.timer.api.exception.TimerException;
import cn.stylefeng.roses.kernel.timer.api.exception.enums.TimerExceptionEnum;
import cn.stylefeng.roses.kernel.timer.modular.entity.SysTimers;
import cn.stylefeng.roses.kernel.timer.modular.mapper.SysTimersMapper;
import cn.stylefeng.roses.kernel.timer.modular.param.SysTimersParam;
import cn.stylefeng.roses.kernel.timer.modular.service.SysTimersService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysTimersServiceImpl
extends ServiceImpl<SysTimersMapper, SysTimers>
implements SysTimersService {
    @Resource
    private TimerExeService timerExeService;

    @Override
    public void add(SysTimersParam sysTimersParam) {
        this.unescapeHtml(sysTimersParam);
        SysTimers sysTimers = new SysTimers();
        BeanUtil.copyProperties((Object)((Object)sysTimersParam), (Object)((Object)sysTimers), (String[])new String[0]);
        sysTimers.setJobStatus(TimerJobStatusEnum.STOP.getCode());
        this.save((Object)sysTimers);
    }

    @Override
    public void del(SysTimersParam sysTimersParam) {
        CronUtil.remove((String)String.valueOf(sysTimersParam.getTimerId()));
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(SysTimers::getDelFlag, (Object)YesOrNotEnum.Y.getCode());
        updateWrapper.eq(SysTimers::getTimerId, (Object)sysTimersParam.getTimerId());
        this.update((Wrapper)updateWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void edit(SysTimersParam sysTimersParam) {
        this.unescapeHtml(sysTimersParam);
        SysTimers oldTimer = this.querySysTimers(sysTimersParam);
        BeanUtil.copyProperties((Object)((Object)sysTimersParam), (Object)((Object)oldTimer), (String[])new String[0]);
        this.updateById((Object)oldTimer);
        Integer jobStatus = oldTimer.getJobStatus();
        if (jobStatus.equals(TimerJobStatusEnum.RUNNING.getCode())) {
            CronUtil.remove((String)String.valueOf(oldTimer.getTimerId()));
            this.timerExeService.startTimer(String.valueOf(sysTimersParam.getTimerId()), sysTimersParam.getCron(), sysTimersParam.getActionClass(), sysTimersParam.getParams());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void start(SysTimersParam sysTimersParam) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)wrapper.set(SysTimers::getJobStatus, (Object)TimerJobStatusEnum.RUNNING.getCode())).eq(SysTimers::getTimerId, (Object)sysTimersParam.getTimerId());
        this.update((Wrapper)wrapper);
        SysTimers sysTimers = this.querySysTimers(sysTimersParam);
        this.timerExeService.startTimer(String.valueOf(sysTimers.getTimerId()), sysTimers.getCron(), sysTimers.getActionClass(), sysTimers.getParams());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void stop(SysTimersParam sysTimersParam) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)wrapper.set(SysTimers::getJobStatus, (Object)TimerJobStatusEnum.STOP.getCode())).eq(SysTimers::getTimerId, (Object)sysTimersParam.getTimerId());
        this.update((Wrapper)wrapper);
        SysTimers sysTimers = this.querySysTimers(sysTimersParam);
        this.timerExeService.stopTimer(String.valueOf(sysTimers.getTimerId()));
    }

    @Override
    public SysTimers detail(SysTimersParam sysTimersParam) {
        return this.querySysTimers(sysTimersParam);
    }

    @Override
    public PageResult<SysTimers> findPage(SysTimersParam sysTimersParam) {
        LambdaQueryWrapper<SysTimers> queryWrapper = this.createWrapper(sysTimersParam);
        Page page = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)queryWrapper);
        return PageResultFactory.createPageResult((Page)page);
    }

    @Override
    public List<SysTimers> findList(SysTimersParam sysTimersParam) {
        LambdaQueryWrapper<SysTimers> queryWrapper = this.createWrapper(sysTimersParam);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<String> getActionClasses() {
        Map timerActionMap = SpringUtil.getBeansOfType(TimerAction.class);
        if (ObjectUtil.isNotEmpty((Object)timerActionMap)) {
            Collection values = timerActionMap.values();
            return values.stream().map(i -> i.getClass().getName()).collect(Collectors.toList());
        }
        return CollectionUtil.newArrayList((Object[])new String[0]);
    }

    private SysTimers querySysTimers(SysTimersParam sysTimersParam) {
        SysTimers sysTimers = (SysTimers)((Object)this.getById(sysTimersParam.getTimerId()));
        if (ObjectUtil.isEmpty((Object)((Object)sysTimers)) || sysTimers.getDelFlag().equals(YesOrNotEnum.Y.getCode())) {
            throw new TimerException((AbstractExceptionEnum)TimerExceptionEnum.JOB_DETAIL_NOT_FOUND, new Object[]{sysTimersParam.getTimerId()});
        }
        return sysTimers;
    }

    private LambdaQueryWrapper<SysTimers> createWrapper(SysTimersParam sysTimersParam) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.ne(SysTimers::getDelFlag, (Object)YesOrNotEnum.Y.getCode());
        queryWrapper.orderByDesc(BaseEntity::getCreateTime);
        if (ObjectUtil.isEmpty((Object)((Object)sysTimersParam))) {
            return queryWrapper;
        }
        String timerName = sysTimersParam.getTimerName();
        Integer jobStatus = sysTimersParam.getJobStatus();
        String actionClass = sysTimersParam.getActionClass();
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)timerName), SysTimers::getTimerName, (Object)timerName);
        queryWrapper.eq(ObjectUtil.isNotNull((Object)jobStatus), SysTimers::getJobStatus, (Object)jobStatus);
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)actionClass), SysTimers::getActionClass, (Object)actionClass);
        return queryWrapper;
    }

    private void unescapeHtml(SysTimersParam sysTimersParam) {
        String params = sysTimersParam.getParams();
        params = HtmlUtil.unescape((String)params);
        sysTimersParam.setParams(params);
    }
}

