/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.api.enums;

import cn.stylefeng.roses.kernel.system.api.exception.SystemModularException;
import cn.stylefeng.roses.kernel.system.api.exception.enums.user.SysUserExceptionEnum;

public enum UserStatusEnum {
    ENABLE(1, "\u542f\u7528"),
    DISABLE(2, "\u7981\u7528"),
    FREEZE(3, "\u51bb\u7ed3");

    private final Integer code;
    private final String message;

    private UserStatusEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public static UserStatusEnum toEnum(Integer code) {
        for (UserStatusEnum userStatusEnum : UserStatusEnum.values()) {
            if (!userStatusEnum.getCode().equals(code)) continue;
            return userStatusEnum;
        }
        return null;
    }

    public static String getCodeMessage(Integer code) {
        UserStatusEnum userStatusEnum = UserStatusEnum.toEnum(code);
        if (userStatusEnum != null) {
            return userStatusEnum.getMessage();
        }
        return "";
    }

    public static void validateUserStatus(Integer code) {
        if (code == null) {
            throw new SystemModularException(SysUserExceptionEnum.REQUEST_USER_STATUS__EMPTY);
        }
        if (ENABLE.getCode().equals(code) || DISABLE.getCode().equals(code) || FREEZE.getCode().equals(code)) {
            return;
        }
        throw new SystemModularException(SysUserExceptionEnum.REQUEST_USER_STATUS_ERROR, code);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }
}

