/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kemel.security.count;

import cn.hutool.core.convert.Convert;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.security.api.CountValidatorApi;
import cn.stylefeng.roses.kernel.security.api.exception.CountValidateException;
import cn.stylefeng.roses.kernel.security.api.exception.enums.CountValidateExceptionEnum;

public class DefaultCountValidator
implements CountValidatorApi {
    private final CacheOperatorApi<Long> cacheOperatorApi;

    public DefaultCountValidator(CacheOperatorApi<Long> cacheOperatorApi) {
        this.cacheOperatorApi = cacheOperatorApi;
    }

    public synchronized void countAndValidate(String key, Long timeWindowSeconds, Long timeWindowMaxCount) throws CountValidateException {
        Object countNumberObject;
        Long countNumber;
        long currentTimeSeconds = System.currentTimeMillis() / 1000L;
        String recordTimeSecondsKey = "COUNT_VALIDATE:" + key + ":" + "RECORD_TIME_SECONDS";
        String countNumberKey = "COUNT_VALIDATE:" + key + ":" + "COUNT_NUMBER";
        Object recordTimeSecondsObject = this.cacheOperatorApi.get(recordTimeSecondsKey);
        Long recordTimeSeconds = Convert.toLong((Object)recordTimeSecondsObject);
        if (recordTimeSeconds == null) {
            recordTimeSeconds = currentTimeSeconds;
        }
        if ((countNumber = Convert.toLong((Object)(countNumberObject = this.cacheOperatorApi.get(countNumberKey)))) == null) {
            countNumber = 0L;
        }
        if (currentTimeSeconds - recordTimeSeconds == timeWindowSeconds) {
            countNumber = 0L;
        } else if (currentTimeSeconds - recordTimeSeconds > timeWindowSeconds) {
            countNumber = 0L;
        } else if (currentTimeSeconds - recordTimeSeconds < timeWindowSeconds) {
            countNumber = countNumber + 1L;
        } else if (recordTimeSeconds.equals(currentTimeSeconds)) {
            countNumber = countNumber + 1L;
        }
        this.cacheOperatorApi.put(recordTimeSecondsKey, (Object)currentTimeSeconds, timeWindowSeconds);
        this.cacheOperatorApi.put(countNumberKey, (Object)countNumber, timeWindowSeconds);
        if (countNumber > timeWindowMaxCount) {
            throw new CountValidateException((AbstractExceptionEnum)CountValidateExceptionEnum.INTERRUPT_EXECUTION);
        }
    }
}

