/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.office.excel;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.office.api.OfficeExcelApi;
import cn.stylefeng.roses.kernel.office.api.exception.OfficeException;
import cn.stylefeng.roses.kernel.office.api.exception.enums.OfficeExceptionEnum;
import cn.stylefeng.roses.kernel.office.api.pojo.report.ExcelExportParam;
import cn.stylefeng.roses.kernel.office.excel.listener.SimpleDataListener;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.support.ExcelTypeEnum;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OfficeExcel
implements OfficeExcelApi {
    private static final Logger log = LoggerFactory.getLogger(OfficeExcel.class);

    public <T> List<T> easyReadToList(InputStream inputStream, Class<T> clazz) {
        if (inputStream == null) {
            return new ArrayList();
        }
        SimpleDataListener readListener = new SimpleDataListener();
        try {
            EasyExcel.read((InputStream)inputStream, clazz, readListener).sheet().doRead();
        }
        catch (Exception e) {
            log.error(e.getMessage());
            String userTip = OfficeExceptionEnum.OFFICE_ERROR.getUserTip();
            String finalUserTip = StrUtil.format((CharSequence)userTip, (Object[])new Object[]{e.getMessage()});
            throw new OfficeException(OfficeExceptionEnum.OFFICE_ERROR.getErrorCode(), finalUserTip);
        }
        return readListener.getDataList();
    }

    public void easyWriteToFile(ExcelExportParam excelExportParam) {
        this.createDefaultValue(excelExportParam);
        ExcelTypeEnum excelTypeEnum = excelExportParam.getExcelTypeEnum();
        String excelFileWriteAbsolutePath = excelExportParam.getExcelFileWriteAbsolutePath();
        try {
            EasyExcel.write((String)excelFileWriteAbsolutePath, (Class)excelExportParam.getClazz()).excelType(excelTypeEnum).sheet(excelExportParam.getSheetName()).doWrite(excelExportParam.getDataList());
        }
        catch (Exception e) {
            log.error(e.getMessage());
            String userTip = OfficeExceptionEnum.OFFICE_ERROR.getUserTip();
            String finalUserTip = StrUtil.format((CharSequence)userTip, (Object[])new Object[]{e.getMessage()});
            throw new OfficeException(OfficeExceptionEnum.OFFICE_ERROR.getErrorCode(), finalUserTip);
        }
    }

    public void easyExportDownload(ExcelExportParam excelExportParam) {
        if (ObjectUtil.isEmpty((Object)excelExportParam)) {
            return;
        }
        try {
            HttpServletResponse response = excelExportParam.getResponse();
            if (response == null) {
                throw new OfficeException((AbstractExceptionEnum)OfficeExceptionEnum.OFFICE_EXCEL_EXPORT_RESPONSE_ISNULL);
            }
            if (excelExportParam.getClazz() == null) {
                throw new OfficeException((AbstractExceptionEnum)OfficeExceptionEnum.OFFICE_EXCEL_EXPORT_ENTITY_CLASS_ISNULL);
            }
            this.createDefaultValue(excelExportParam);
            ExcelTypeEnum excelTypeEnum = excelExportParam.getExcelTypeEnum();
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            String fileName = URLEncoder.encode(excelExportParam.getFileName(), "UTF-8").replaceAll("\\+", "%20");
            response.setHeader("Content-disposition", String.format("%s%s", "attachment;filename*=utf-8''", fileName, excelTypeEnum.getValue()));
            EasyExcel.write((OutputStream)response.getOutputStream(), (Class)excelExportParam.getClazz()).excelType(excelTypeEnum).sheet(excelExportParam.getSheetName()).doWrite(excelExportParam.getDataList());
        }
        catch (Exception e) {
            log.error(e.getMessage());
            String userTip = OfficeExceptionEnum.OFFICE_ERROR.getUserTip();
            String finalUserTip = StrUtil.format((CharSequence)userTip, (Object[])new Object[]{e.getMessage()});
            throw new OfficeException(OfficeExceptionEnum.OFFICE_ERROR.getErrorCode(), finalUserTip);
        }
    }

    private void createDefaultValue(ExcelExportParam param) {
        if (StrUtil.isEmpty((CharSequence)param.getSheetName())) {
            param.setSheetName("Sheet");
        }
        if (StrUtil.isEmpty((CharSequence)param.getFileName())) {
            param.setFileName("export");
        }
        if (param.getExcelTypeEnum() == null) {
            param.setExcelTypeEnum(ExcelTypeEnum.XLSX);
        }
    }
}

