/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.config.modular.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.stylefeng.roses.kernel.config.api.ConfigInitCallbackApi;
import cn.stylefeng.roses.kernel.config.api.ConfigInitStrategyApi;
import cn.stylefeng.roses.kernel.config.api.context.ConfigContext;
import cn.stylefeng.roses.kernel.config.api.exception.ConfigException;
import cn.stylefeng.roses.kernel.config.api.exception.enums.ConfigExceptionEnum;
import cn.stylefeng.roses.kernel.config.api.pojo.ConfigInitItem;
import cn.stylefeng.roses.kernel.config.api.pojo.ConfigInitRequest;
import cn.stylefeng.roses.kernel.config.modular.entity.SysConfig;
import cn.stylefeng.roses.kernel.config.modular.mapper.SysConfigMapper;
import cn.stylefeng.roses.kernel.config.modular.param.SysConfigParam;
import cn.stylefeng.roses.kernel.config.modular.service.SysConfigService;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.rule.enums.StatusEnum;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysConfigServiceImpl
extends ServiceImpl<SysConfigMapper, SysConfig>
implements SysConfigService {
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(SysConfigParam sysConfigParam) {
        SysConfig sysConfig = new SysConfig();
        BeanUtil.copyProperties((Object)((Object)sysConfigParam), (Object)((Object)sysConfig), (String[])new String[0]);
        sysConfig.setStatusFlag(StatusEnum.ENABLE.getCode());
        this.save((Object)sysConfig);
        ConfigContext.me().putConfig(sysConfigParam.getConfigCode(), (Object)sysConfigParam.getConfigValue());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(SysConfigParam sysConfigParam) {
        SysConfig sysConfig = this.querySysConfig(sysConfigParam);
        if (sysConfig == null) {
            String userTip = StrUtil.format((CharSequence)ConfigExceptionEnum.CONFIG_NOT_EXIST.getUserTip(), (Object[])new Object[]{"id: " + sysConfigParam.getConfigId()});
            throw new ConfigException((AbstractExceptionEnum)ConfigExceptionEnum.CONFIG_NOT_EXIST, userTip);
        }
        if (YesOrNotEnum.Y.getCode().equals(sysConfig.getSysFlag())) {
            throw new ConfigException((AbstractExceptionEnum)ConfigExceptionEnum.CONFIG_SYS_CAN_NOT_DELETE);
        }
        sysConfig.setStatusFlag(StatusEnum.DISABLE.getCode());
        sysConfig.setDelFlag(YesOrNotEnum.Y.getCode());
        this.updateById((Object)sysConfig);
        ConfigContext.me().deleteConfig(sysConfigParam.getConfigCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void edit(SysConfigParam sysConfigParam) {
        SysConfig sysConfig = this.querySysConfig(sysConfigParam);
        BeanUtil.copyProperties((Object)((Object)sysConfigParam), (Object)((Object)sysConfig), (String[])new String[0]);
        sysConfig.setStatusFlag(null);
        this.updateById((Object)sysConfig);
        ConfigContext.me().putConfig(sysConfigParam.getConfigCode(), (Object)sysConfigParam.getConfigValue());
    }

    @Override
    public SysConfig detail(SysConfigParam sysConfigParam) {
        return this.querySysConfig(sysConfigParam);
    }

    @Override
    public PageResult<SysConfig> findPage(SysConfigParam sysConfigParam) {
        LambdaQueryWrapper<SysConfig> wrapper = this.createWrapper(sysConfigParam);
        Page page = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)page);
    }

    @Override
    public List<SysConfig> findList(SysConfigParam sysConfigParam) {
        LambdaQueryWrapper<SysConfig> wrapper = this.createWrapper(sysConfigParam);
        return this.list((Wrapper)wrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void initConfig(ConfigInitRequest configInitRequest) {
        if (configInitRequest == null || configInitRequest.getSysConfigs() == null) {
            throw new ConfigException((AbstractExceptionEnum)ConfigExceptionEnum.CONFIG_INIT_ERROR);
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SysConfig::getConfigCode, (Object)"SYS_CONFIG_INIT_FLAG");
        SysConfig tempSysConfig = (SysConfig)((Object)this.getOne((Wrapper)lambdaQueryWrapper, false));
        String alreadyInit = tempSysConfig.getConfigValue();
        if (Convert.toBool((Object)alreadyInit).booleanValue()) {
            throw new ConfigException((AbstractExceptionEnum)ConfigExceptionEnum.CONFIG_INIT_ALREADY);
        }
        Map beans = SpringUtil.getBeansOfType(ConfigInitCallbackApi.class);
        if (ObjectUtil.isNotNull((Object)beans)) {
            for (ConfigInitCallbackApi initCallbackApi : beans.values()) {
                initCallbackApi.initBefore();
            }
        }
        Map sysConfigs = configInitRequest.getSysConfigs();
        sysConfigs.put("SYS_CONFIG_INIT_FLAG", "true");
        for (Map.Entry entry : sysConfigs.entrySet()) {
            String configCode = (String)entry.getKey();
            String configValue = (String)entry.getValue();
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(SysConfig::getConfigCode, (Object)configCode);
            SysConfig sysConfig = (SysConfig)((Object)this.getOne((Wrapper)wrapper, false));
            if (sysConfig == null) continue;
            sysConfig.setConfigValue(configValue);
            this.updateById((Object)sysConfig);
            ConfigContext.me().putConfig(configCode, (Object)configValue);
        }
        if (ObjectUtil.isNotNull((Object)beans)) {
            for (ConfigInitCallbackApi initCallbackApi : beans.values()) {
                initCallbackApi.initAfter();
            }
        }
    }

    @Override
    public Boolean getInitConfigFlag() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysConfig::getConfigCode, (Object)"SYS_CONFIG_INIT_FLAG");
        SysConfig sysConfig = (SysConfig)((Object)this.getOne((Wrapper)wrapper, false));
        if (sysConfig == null) {
            return true;
        }
        String configValue = sysConfig.getConfigValue();
        if (StrUtil.isEmpty((CharSequence)configValue)) {
            return true;
        }
        return Convert.toBool((Object)sysConfig.getConfigValue());
    }

    @Override
    public List<ConfigInitItem> getInitConfigs() {
        ArrayList<ConfigInitItem> configInitItemList = new ArrayList<ConfigInitItem>();
        Map beans = SpringUtil.getBeansOfType(ConfigInitStrategyApi.class);
        for (ConfigInitStrategyApi value : beans.values()) {
            configInitItemList.addAll(value.getInitConfigs());
        }
        return configInitItemList;
    }

    private SysConfig querySysConfig(SysConfigParam sysConfigParam) {
        SysConfig sysConfig = (SysConfig)((Object)this.getById(sysConfigParam.getConfigId()));
        if (ObjectUtil.isEmpty((Object)((Object)sysConfig)) || sysConfig.getDelFlag().equals(YesOrNotEnum.Y.getCode())) {
            String userTip = StrUtil.format((CharSequence)ConfigExceptionEnum.CONFIG_NOT_EXIST.getUserTip(), (Object[])new Object[]{"id: " + sysConfigParam.getConfigId()});
            throw new ConfigException((AbstractExceptionEnum)ConfigExceptionEnum.CONFIG_NOT_EXIST, userTip);
        }
        return sysConfig;
    }

    private LambdaQueryWrapper<SysConfig> createWrapper(SysConfigParam sysConfigParam) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.ne(SysConfig::getDelFlag, (Object)YesOrNotEnum.Y.getCode());
        queryWrapper.orderByDesc(SysConfig::getGroupCode);
        if (ObjectUtil.isEmpty((Object)((Object)sysConfigParam))) {
            return queryWrapper;
        }
        String configName = sysConfigParam.getConfigName();
        String configCode = sysConfigParam.getConfigCode();
        String groupCode = sysConfigParam.getGroupCode();
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)configName), SysConfig::getConfigName, (Object)configName);
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)configCode), SysConfig::getConfigCode, (Object)configCode);
        queryWrapper.eq(ObjectUtil.isNotEmpty((Object)groupCode), SysConfig::getGroupCode, (Object)groupCode);
        return queryWrapper;
    }
}

