/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel.cell;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.StyleSet;
import cn.hutool.poi.excel.cell.CellEditor;
import cn.hutool.poi.excel.cell.CellLocation;
import cn.hutool.poi.excel.cell.FormulaCellValue;
import cn.hutool.poi.excel.cell.NullCell;
import cn.hutool.poi.excel.editors.TrimEditor;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.ss.util.SheetUtil;

public class CellUtil {
    public static Object getCellValue(Cell cell) {
        return CellUtil.getCellValue(cell, false);
    }

    public static Object getCellValue(Cell cell, boolean isTrimCellValue) {
        if (null == cell) {
            return null;
        }
        return CellUtil.getCellValue(cell, cell.getCellTypeEnum(), isTrimCellValue);
    }

    public static Object getCellValue(Cell cell, CellEditor cellEditor) {
        return CellUtil.getCellValue(cell, null, cellEditor);
    }

    public static Object getCellValue(Cell cell, CellType cellType, boolean isTrimCellValue) {
        return CellUtil.getCellValue(cell, cellType, isTrimCellValue ? new TrimEditor() : null);
    }

    public static Object getCellValue(Cell cell, CellType cellType, CellEditor cellEditor) {
        Object value;
        Cell mergedCell;
        if (null == cell) {
            return null;
        }
        if (cell instanceof NullCell) {
            return null == cellEditor ? null : cellEditor.edit(cell, null);
        }
        if (null == cellType) {
            cellType = cell.getCellTypeEnum();
        }
        if ((mergedCell = CellUtil.getMergedRegionCell(cell)) != cell) {
            cell = mergedCell;
            cellType = cell.getCellTypeEnum();
        }
        switch (cellType) {
            case NUMERIC: {
                value = CellUtil.getNumericValue(cell);
                break;
            }
            case BOOLEAN: {
                value = cell.getBooleanCellValue();
                break;
            }
            case FORMULA: {
                value = CellUtil.getCellValue(cell, cell.getCachedFormulaResultTypeEnum(), cellEditor);
                break;
            }
            case BLANK: {
                value = "";
                break;
            }
            case ERROR: {
                FormulaError error = FormulaError.forInt((byte)cell.getErrorCellValue());
                value = null == error ? "" : error.getString();
                break;
            }
            default: {
                value = cell.getStringCellValue();
            }
        }
        return null == cellEditor ? value : cellEditor.edit(cell, value);
    }

    public static void setCellValue(Cell cell, Object value, StyleSet styleSet, boolean isHeader) {
        if (null == cell) {
            return;
        }
        if (null != styleSet) {
            CellStyle headCellStyle = styleSet.getHeadCellStyle();
            CellStyle cellStyle = styleSet.getCellStyle();
            if (isHeader && null != headCellStyle) {
                cell.setCellStyle(headCellStyle);
            } else if (null != cellStyle) {
                cell.setCellStyle(cellStyle);
            }
        }
        if (value instanceof Date) {
            if (null != styleSet && null != styleSet.getCellStyleForDate()) {
                cell.setCellStyle(styleSet.getCellStyleForDate());
            }
        } else if (value instanceof TemporalAccessor) {
            if (null != styleSet && null != styleSet.getCellStyleForDate()) {
                cell.setCellStyle(styleSet.getCellStyleForDate());
            }
        } else if (value instanceof Calendar) {
            if (null != styleSet && null != styleSet.getCellStyleForDate()) {
                cell.setCellStyle(styleSet.getCellStyleForDate());
            }
        } else if (value instanceof Number && (value instanceof Double || value instanceof Float || value instanceof BigDecimal) && null != styleSet && null != styleSet.getCellStyleForNumber()) {
            cell.setCellStyle(styleSet.getCellStyleForNumber());
        }
        CellUtil.setCellValue(cell, value, null);
    }

    public static void setCellValue(Cell cell, Object value, CellStyle style) {
        if (null == cell) {
            return;
        }
        if (null != style) {
            cell.setCellStyle(style);
        }
        if (null == value) {
            cell.setCellValue("");
        } else if (value instanceof FormulaCellValue) {
            cell.setCellFormula(((FormulaCellValue)value).getValue());
        } else if (value instanceof Date) {
            cell.setCellValue((Date)value);
        } else if (value instanceof TemporalAccessor) {
            if (value instanceof Instant) {
                cell.setCellValue(Date.from((Instant)value));
            } else if (value instanceof LocalDateTime) {
                cell.setCellValue((LocalDateTime)value);
            } else if (value instanceof LocalDate) {
                cell.setCellValue((LocalDate)value);
            }
        } else if (value instanceof Calendar) {
            cell.setCellValue((Calendar)value);
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else if (value instanceof RichTextString) {
            cell.setCellValue((RichTextString)value);
        } else if (value instanceof Number) {
            cell.setCellValue(((Number)value).doubleValue());
        } else {
            cell.setCellValue(value.toString());
        }
    }

    public static Cell getCell(Row row, int cellIndex) {
        Cell cell = row.getCell(cellIndex);
        if (null == cell) {
            return new NullCell(row, cellIndex);
        }
        return cell;
    }

    public static Cell getOrCreateCell(Row row, int cellIndex) {
        Cell cell = row.getCell(cellIndex);
        if (null == cell) {
            cell = row.createCell(cellIndex);
        }
        return cell;
    }

    public static boolean isMergedRegion(Sheet sheet, String locationRef) {
        CellLocation cellLocation = ExcelUtil.toLocation(locationRef);
        return CellUtil.isMergedRegion(sheet, cellLocation.getX(), cellLocation.getY());
    }

    public static boolean isMergedRegion(Cell cell) {
        return CellUtil.isMergedRegion(cell.getSheet(), cell.getColumnIndex(), cell.getRowIndex());
    }

    public static boolean isMergedRegion(Sheet sheet, int x, int y) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            if (y < ca.getFirstRow() || y > ca.getLastRow() || x < ca.getFirstColumn() || x > ca.getLastColumn()) continue;
            return true;
        }
        return false;
    }

    public static int mergingCells(Sheet sheet, int firstRow, int lastRow, int firstColumn, int lastColumn, CellStyle cellStyle) {
        CellRangeAddress cellRangeAddress = new CellRangeAddress(firstRow, lastRow, firstColumn, lastColumn);
        if (null != cellStyle) {
            RegionUtil.setBorderTop((BorderStyle)cellStyle.getBorderTopEnum(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBorderRight((BorderStyle)cellStyle.getBorderRightEnum(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBorderBottom((BorderStyle)cellStyle.getBorderBottomEnum(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
            RegionUtil.setBorderLeft((BorderStyle)cellStyle.getBorderLeftEnum(), (CellRangeAddress)cellRangeAddress, (Sheet)sheet);
        }
        return sheet.addMergedRegion(cellRangeAddress);
    }

    public static Object getMergedRegionValue(Sheet sheet, String locationRef) {
        CellLocation cellLocation = ExcelUtil.toLocation(locationRef);
        return CellUtil.getMergedRegionValue(sheet, cellLocation.getX(), cellLocation.getY());
    }

    public static Object getMergedRegionValue(Sheet sheet, int x, int y) {
        return CellUtil.getCellValue(SheetUtil.getCell((Sheet)sheet, (int)x, (int)y));
    }

    public static Cell getMergedRegionCell(Cell cell) {
        if (null == cell) {
            return null;
        }
        return (Cell)ObjectUtil.defaultIfNull((Object)CellUtil.getCellIfMergedRegion(cell.getSheet(), cell.getColumnIndex(), cell.getRowIndex()), (Object)cell);
    }

    public static Cell getMergedRegionCell(Sheet sheet, int x, int y) {
        return (Cell)ObjectUtil.defaultIfNull((Object)CellUtil.getCellIfMergedRegion(sheet, x, y), (Object)SheetUtil.getCell((Sheet)sheet, (int)y, (int)x));
    }

    public static void setComment(Cell cell, String commentText, String commentAuthor, ClientAnchor anchor) {
        Sheet sheet = cell.getSheet();
        Workbook wb = sheet.getWorkbook();
        Drawing drawing = sheet.createDrawingPatriarch();
        CreationHelper factory = wb.getCreationHelper();
        if (anchor == null) {
            anchor = factory.createClientAnchor();
            anchor.setCol1(cell.getColumnIndex() + 1);
            anchor.setCol2(cell.getColumnIndex() + 3);
            anchor.setRow1(cell.getRowIndex());
            anchor.setRow2(cell.getRowIndex() + 2);
        }
        Comment comment = drawing.createCellComment(anchor);
        comment.setString(factory.createRichTextString(commentText));
        comment.setAuthor(StrUtil.nullToEmpty((CharSequence)commentText));
        cell.setCellComment(comment);
    }

    private static Cell getCellIfMergedRegion(Sheet sheet, int x, int y) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            if (!ca.isInRange(y, x)) continue;
            return SheetUtil.getCell((Sheet)sheet, (int)ca.getFirstRow(), (int)ca.getFirstColumn());
        }
        return null;
    }

    private static Object getNumericValue(Cell cell) {
        double value = cell.getNumericCellValue();
        CellStyle style = cell.getCellStyle();
        if (null != style) {
            long longPart;
            short formatIndex = style.getDataFormat();
            if (CellUtil.isDateType(cell, formatIndex)) {
                return DateUtil.date((Date)cell.getDateCellValue());
            }
            String format = style.getDataFormatString();
            if (null != format && format.indexOf(46) < 0 && (double)(longPart = (long)value) == value) {
                return longPart;
            }
        }
        return Double.parseDouble(NumberToTextConverter.toText((double)value));
    }

    private static boolean isDateType(Cell cell, int formatIndex) {
        if (formatIndex == 14 || formatIndex == 31 || formatIndex == 57 || formatIndex == 58 || formatIndex == 20 || formatIndex == 32) {
            return true;
        }
        return org.apache.poi.ss.usermodel.DateUtil.isCellDateFormatted((Cell)cell);
    }
}

