/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.convert.ConvertException;
import cn.hutool.core.getter.OptNullBasicTypeFromObjectGetter;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONConverter;
import cn.hutool.json.JSONNull;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;

public abstract class JSONGetter<K>
extends OptNullBasicTypeFromObjectGetter<K> {
    public boolean isNull(K key) {
        return JSONNull.NULL.equals(this.getObj(key));
    }

    public String getStrEscaped(K key) {
        return this.getStrEscaped(key, null);
    }

    public String getStrEscaped(K key, String defaultValue) {
        return JSONUtil.escape(this.getStr(key, defaultValue));
    }

    public JSONArray getJSONArray(K key) {
        Object object = this.getObj(key);
        if (null == object) {
            return null;
        }
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        return new JSONArray(object);
    }

    public JSONObject getJSONObject(K key) {
        Object object = this.getObj(key);
        if (null == object) {
            return null;
        }
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        return new JSONObject(object);
    }

    public <T> T getBean(K key, Class<T> beanType) {
        JSONObject obj = this.getJSONObject(key);
        return (T)(null == obj ? null : obj.toBean(beanType));
    }

    public <T> T get(K key, Class<T> type) throws ConvertException {
        return this.get(key, type, false);
    }

    public <T> T get(K key, Class<T> type, boolean ignoreError) throws ConvertException {
        Object value = this.getObj(key);
        if (null == value) {
            return null;
        }
        return JSONConverter.jsonConvert(type, value, ignoreError);
    }
}

