/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.util.StrUtil;

public class JSONStrFormater {
    private static String SPACE = "    ";
    private static char NEW_LINE = (char)10;

    public static String format(String json) {
        StringBuffer result = new StringBuffer();
        Character wrapChar = null;
        boolean isEscapeMode = false;
        int length = json.length();
        int number = 0;
        char key = '\u0000';
        for (int i = 0; i < length; ++i) {
            key = json.charAt(i);
            if ('\"' == key || '\'' == key) {
                if (null == wrapChar) {
                    wrapChar = Character.valueOf(key);
                } else if (isEscapeMode) {
                    isEscapeMode = false;
                } else if (wrapChar.equals(Character.valueOf(key))) {
                    wrapChar = null;
                }
                result.append(key);
                continue;
            }
            if ('\\' == key) {
                if (null != wrapChar) {
                    isEscapeMode = !isEscapeMode;
                    result.append(key);
                    continue;
                }
                result.append(key);
            }
            if (null != wrapChar) {
                result.append(key);
                continue;
            }
            if (key == '[' || key == '{') {
                if (i - 1 > 0 && json.charAt(i - 1) == ':') {
                    result.append(NEW_LINE);
                    result.append(JSONStrFormater.indent(number));
                }
                result.append(key);
                result.append(NEW_LINE);
                result.append(JSONStrFormater.indent(++number));
                continue;
            }
            if (key == ']' || key == '}') {
                result.append(NEW_LINE);
                result.append(JSONStrFormater.indent(--number));
                result.append(key);
                if (i + 1 >= length || json.charAt(i + 1) == ',') continue;
                result.append(NEW_LINE);
                continue;
            }
            if (key == ',') {
                result.append(key);
                result.append(NEW_LINE);
                result.append(JSONStrFormater.indent(number));
                continue;
            }
            result.append(key);
        }
        return result.toString();
    }

    private static String indent(int number) {
        return StrUtil.repeat((CharSequence)SPACE, (int)number);
    }
}

