/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.date;

import cn.hutool.core.convert.NumberChineseFormatter;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.Zodiac;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ChineseDate {
    private static final Date baseDate = DateUtil.parseDate("1900-01-31");
    private int year;
    private int month;
    private int day;
    private boolean leap;
    private String[] chineseNumber = new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u5341\u4e00", "\u5341\u4e8c"};
    private String[] chineseNumberName = new String[]{"\u6b63", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u5341\u4e00", "\u814a"};
    private long[] lunarInfo = new long[]{19416L, 19168L, 42352L, 21717L, 53856L, 55632L, 91476L, 22176L, 39632L, 21970L, 19168L, 42422L, 42192L, 53840L, 119381L, 46400L, 54944L, 44450L, 38320L, 84343L, 18800L, 42160L, 46261L, 27216L, 27968L, 109396L, 11104L, 38256L, 21234L, 18800L, 25958L, 54432L, 59984L, 28309L, 23248L, 11104L, 100067L, 37600L, 116951L, 51536L, 54432L, 120998L, 46416L, 22176L, 107956L, 9680L, 37584L, 53938L, 43344L, 46423L, 27808L, 46416L, 86869L, 19872L, 42448L, 83315L, 21200L, 43432L, 59728L, 27296L, 44710L, 43856L, 19296L, 43748L, 42352L, 21088L, 62051L, 55632L, 23383L, 22176L, 38608L, 19925L, 19152L, 42192L, 54484L, 53840L, 54616L, 46400L, 46496L, 103846L, 38320L, 18864L, 43380L, 42160L, 45690L, 27216L, 27968L, 44870L, 43872L, 38256L, 19189L, 18800L, 25776L, 29859L, 59984L, 27480L, 21952L, 43872L, 38613L, 37600L, 51552L, 55636L, 54432L, 55888L, 30034L, 22176L, 43959L, 9680L, 37584L, 51893L, 43344L, 46240L, 47780L, 44368L, 21977L, 19360L, 42416L, 86390L, 21168L, 43312L, 31060L, 27296L, 44368L, 23378L, 19296L, 42726L, 42208L, 53856L, 60005L, 54576L, 23200L, 30371L, 38608L, 19415L, 19152L, 42192L, 118966L, 53840L, 54560L, 56645L, 46496L, 22224L, 21938L, 18864L, 42359L, 42160L, 43600L, 111189L, 27936L, 44448L};
    private String[] lFtv = new String[]{"0101 \u6625\u8282", "0102 \u5927\u5e74\u521d\u4e8c", "0103 \u5927\u5e74\u521d\u4e09", "0104 \u5927\u5e74\u521d\u56db", "0105 \u5927\u5e74\u521d\u4e94", "0106 \u5927\u5e74\u521d\u516d", "0107 \u5927\u5e74\u521d\u4e03", "0105 \u8def\u795e\u751f\u65e5", "0115 \u5143\u5bb5\u8282", "0202 \u9f99\u62ac\u5934", "0219 \u89c2\u4e16\u97f3\u5723\u8bde", "0404 \u5bd2\u98df\u8282", "0408 \u4f5b\u8bde\u8282 ", "0505 \u7aef\u5348\u8282", "0606 \u5929\u8d36\u8282 \u59d1\u59d1\u8282", "0624 \u5f5d\u65cf\u706b\u628a\u8282", "0707 \u4e03\u5915\u60c5\u4eba\u8282", "0714 \u9b3c\u8282(\u5357\u65b9)", "0715 \u76c2\u5170\u8282", "0730 \u5730\u85cf\u8282", "0815 \u4e2d\u79cb\u8282", "0909 \u91cd\u9633\u8282", "1001 \u796d\u7956\u8282", "1117 \u963f\u5f25\u9640\u4f5b\u5723\u8bde", "1208 \u814a\u516b\u8282 \u91ca\u8fe6\u5982\u6765\u6210\u9053\u65e5", "1223 \u8fc7\u5c0f\u5e74", "1229 \u814a\u6708\u4e8c\u5341\u4e5d", "1230 \u9664\u5915"};

    public ChineseDate(Date date) {
        int iMonth;
        int iYear;
        int offset = (int)((date.getTime() - baseDate.getTime()) / 86400000L);
        int monCyl = 14;
        int daysOfYear = 0;
        for (iYear = 1900; iYear < 2050 && offset > 0; ++iYear) {
            daysOfYear = this.yearDays(iYear);
            offset -= daysOfYear;
            monCyl += 12;
        }
        if (offset < 0) {
            offset += daysOfYear;
            --iYear;
            monCyl -= 12;
        }
        this.year = iYear;
        int leapMonth = this.leapMonth(iYear);
        this.leap = false;
        int daysOfMonth = 0;
        for (iMonth = 1; iMonth < 13 && offset > 0; ++iMonth) {
            if (leapMonth > 0 && iMonth == leapMonth + 1 && !this.leap) {
                --iMonth;
                this.leap = true;
                daysOfMonth = this.leapDays(this.year);
            } else {
                daysOfMonth = this.monthDays(this.year, iMonth);
            }
            offset -= daysOfMonth;
            if (this.leap && iMonth == leapMonth + 1) {
                this.leap = false;
            }
            if (this.leap) continue;
            ++monCyl;
        }
        if (offset == 0 && leapMonth > 0 && iMonth == leapMonth + 1) {
            if (this.leap) {
                this.leap = false;
            } else {
                this.leap = true;
                --iMonth;
                --monCyl;
            }
        }
        if (offset < 0) {
            offset += daysOfMonth;
            --iMonth;
            --monCyl;
        }
        this.month = iMonth;
        this.day = offset + 1;
    }

    public int getChineseYear() {
        return this.year;
    }

    public String getChineseMonth() {
        return (this.leap ? "\u95f0" : "") + NumberChineseFormatter.format(this.month, false) + "\u6708";
    }

    public String getChineseMonthName() {
        return (this.leap ? "\u95f0" : "") + this.chineseNumberName[this.month - 1] + "\u6708";
    }

    public String getChineseDay() {
        int n;
        String[] chineseTen = new String[]{"\u521d", "\u5341", "\u5eff", "\u5345"};
        int n2 = n = this.day % 10 == 0 ? 9 : this.day % 10 - 1;
        if (this.day > 30) {
            return "";
        }
        return this.day == 10 ? "\u521d\u5341" : chineseTen[this.day / 10] + NumberChineseFormatter.format(n + 1, false);
    }

    public String getFestivals() {
        StringBuilder currentChineseDate = new StringBuilder();
        if (this.month < 10) {
            currentChineseDate.append('0');
        }
        currentChineseDate.append(this.month);
        if (this.day < 10) {
            currentChineseDate.append('0');
        }
        currentChineseDate.append(this.day);
        ArrayList<String> getFestivalsList = new ArrayList<String>();
        for (String fv : this.lFtv) {
            List<String> split = StrUtil.split((CharSequence)fv, ' ');
            if (!split.get(0).contentEquals(currentChineseDate)) continue;
            getFestivalsList.add(split.get(1));
        }
        return StrUtil.join(",", getFestivalsList);
    }

    public String getChineseZodiac() {
        return Zodiac.getChineseZodiac(this.year);
    }

    public String getCyclical() {
        int num = this.year - 1900 + 36;
        return ChineseDate.cyclicalm(num);
    }

    public String toString() {
        return String.format("%s%s\u5e74 %s%s", this.getCyclical(), this.getChineseZodiac(), this.getChineseMonthName(), this.getChineseDay());
    }

    private static String cyclicalm(int num) {
        String[] Gan = new String[]{"\u7532", "\u4e59", "\u4e19", "\u4e01", "\u620a", "\u5df1", "\u5e9a", "\u8f9b", "\u58ec", "\u7678"};
        String[] Zhi = new String[]{"\u5b50", "\u4e11", "\u5bc5", "\u536f", "\u8fb0", "\u5df3", "\u5348", "\u672a", "\u7533", "\u9149", "\u620c", "\u4ea5"};
        return Gan[num % 10] + Zhi[num % 12];
    }

    private int yearDays(int y) {
        int sum = 348;
        for (int i = 32768; i > 8; i >>= 1) {
            if ((this.lunarInfo[y - 1900] & (long)i) == 0L) continue;
            ++sum;
        }
        return sum + this.leapDays(y);
    }

    private int leapDays(int y) {
        if (this.leapMonth(y) != 0) {
            return (this.lunarInfo[y - 1900] & 0x10000L) != 0L ? 30 : 29;
        }
        return 0;
    }

    private int monthDays(int y, int m) {
        return (this.lunarInfo[y - 1900] & (long)(65536 >> m)) == 0L ? 29 : 30;
    }

    private int leapMonth(int y) {
        return (int)(this.lunarInfo[y - 1900] & 0xFL);
    }
}

