/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron.pattern;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.cron.pattern.matcher.PatternMatcher;
import cn.hutool.cron.pattern.parser.PatternParser;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;

public class CronPattern {
    private final String pattern;
    private final List<PatternMatcher> matchers;

    public static CronPattern of(String pattern) {
        return new CronPattern(pattern);
    }

    public CronPattern(String pattern) {
        this.pattern = pattern;
        this.matchers = PatternParser.parse(pattern);
    }

    public boolean match(long millis, boolean isMatchSecond) {
        return this.match(TimeZone.getDefault(), millis, isMatchSecond);
    }

    public boolean match(TimeZone timezone, long millis, boolean isMatchSecond) {
        GregorianCalendar calendar = new GregorianCalendar(timezone);
        calendar.setTimeInMillis(millis);
        return this.match(calendar, isMatchSecond);
    }

    public boolean match(Calendar calendar, boolean isMatchSecond) {
        int second = isMatchSecond ? calendar.get(13) : -1;
        int minute = calendar.get(12);
        int hour = calendar.get(11);
        int dayOfMonth = calendar.get(5);
        int month = calendar.get(2) + 1;
        int dayOfWeek = calendar.get(7) - 1;
        int year = calendar.get(1);
        return this.match(second, minute, hour, dayOfMonth, month, dayOfWeek, year);
    }

    public Calendar nextMatchAfter(Calendar calendar) {
        int second = calendar.get(13);
        int minute = calendar.get(12);
        int hour = calendar.get(11);
        int dayOfMonth = calendar.get(5);
        int month = calendar.get(2) + 1;
        int dayOfWeek = calendar.get(7) - 1;
        int year = calendar.get(1);
        return this.nextMatchAfter(new int[]{second, minute, hour, dayOfMonth, month, dayOfWeek, year}, calendar.getTimeZone());
    }

    public String toString() {
        return this.pattern;
    }

    private boolean match(int second, int minute, int hour, int dayOfMonth, int month, int dayOfWeek, int year) {
        for (PatternMatcher matcher : this.matchers) {
            if (!matcher.match(second, minute, hour, dayOfMonth, month, dayOfWeek, year)) continue;
            return true;
        }
        return false;
    }

    private Calendar nextMatchAfter(int[] values, TimeZone zone) {
        ArrayList<Calendar> nextMatches = new ArrayList<Calendar>(this.matchers.size());
        for (PatternMatcher matcher : this.matchers) {
            nextMatches.add(matcher.nextMatchAfter(values, zone));
        }
        return (Calendar)CollUtil.min(nextMatches);
    }
}

