/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.spring;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

@ConditionalOnClass(value={OriginTrackedMapPropertySource.class})
public class SaHistoryVersionInject
implements EnvironmentAware {
    public void setEnvironment(Environment env) {
        try {
            ConfigurableEnvironment c = (ConfigurableEnvironment)env;
            MutablePropertySources sources = c.getPropertySources();
            LinkedHashMap newMap = new LinkedHashMap();
            for (PropertySource source : sources) {
                if (!source.getName().startsWith("applicationConfig")) continue;
                Map bootProp = (Map)source.getSource();
                for (String key : bootProp.keySet()) {
                    if (key == null || !key.startsWith("spring.sa-token.")) continue;
                    String newKey = key.substring(7);
                    newMap.put(newKey, bootProp.get(key));
                }
            }
            if (newMap.size() > 0) {
                System.err.println("\nSa-Token Warning: \u5f53\u524d\u914d\u7f6e\u6587\u4ef6\u65b9\u5f0f\u5df2\u8fc7\u65f6\uff0c\u8bf7\u66f4\u6539\u914d\u7f6e\u524d\u7f00\uff1a\u539f [spring.sa-token.] \u66f4\u6539\u4e3a [sa-token.]\nSa-Token Warning: \u5f53\u524d\u7248\u672c(v1.28.0)\u6682\u65f6\u5411\u4e0b\u517c\u5bb9\uff0c\u672a\u6765\u7248\u672c\u53ef\u80fd\u4f1a\u5b8c\u5168\u79fb\u9664\u65e7\u5f62\u5f0f");
                OriginTrackedMapPropertySource source = new OriginTrackedMapPropertySource("SaHistoryVersionInjectProperty", newMap);
                c.getPropertySources().addLast((PropertySource)source);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

