/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.view;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.graph.builder.ExcelChartBuildService;
import cn.afterturn.easypoi.view.MiniAbstractExcelView;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.stereotype.Controller;

@Controller(value="MapGraphExcelView")
public class MapGraphExcelView
extends MiniAbstractExcelView {
    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String codedFileName = "\u4e34\u65f6\u6587\u4ef6";
        ExportParams params = (ExportParams)model.get("params");
        List entityList = (List)model.get("EntityList");
        List mapList = (List)model.get("mapList");
        List graphDefinedList = (List)model.get("graphDefined");
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)params, (List)entityList, (Collection)mapList);
        ExcelChartBuildService.createExcelChart((Workbook)workbook, (List)graphDefinedList, (Boolean)params.isDynamicData(), (Boolean)params.isAppendGraph());
        if (model.containsKey("fileName")) {
            codedFileName = (String)model.get("fileName");
        }
        codedFileName = workbook instanceof HSSFWorkbook ? codedFileName + ".xls" : codedFileName + ".xlsx";
        codedFileName = MapGraphExcelView.isIE(request) ? URLEncoder.encode(codedFileName, "UTF8") : new String(codedFileName.getBytes("UTF-8"), "ISO-8859-1");
        response.setHeader("content-disposition", "attachment;filename=" + codedFileName);
        ServletOutputStream out = response.getOutputStream();
        workbook.write((OutputStream)out);
        out.flush();
    }
}

