/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big;

import ch.obermuhlner.math.big.BigComplex;
import ch.obermuhlner.math.big.BigDecimalMath;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.List;

public class BigComplexMath {
    private static final BigDecimal TWO = BigDecimal.valueOf(2L);

    public static BigComplex reciprocal(BigComplex x, MathContext mathContext) {
        return x.reciprocal(mathContext);
    }

    public static BigComplex conjugate(BigComplex x) {
        return x.conjugate();
    }

    public static BigDecimal abs(BigComplex x, MathContext mathContext) {
        return x.abs(mathContext);
    }

    public static BigDecimal absSquare(BigComplex x, MathContext mathContext) {
        return x.absSquare(mathContext);
    }

    public static BigDecimal angle(BigComplex x, MathContext mathContext) {
        return x.angle(mathContext);
    }

    public static BigComplex factorial(BigComplex x, MathContext mathContext) {
        if (x.isReal() && BigDecimalMath.isIntValue(x.re)) {
            return BigComplex.valueOf(BigDecimalMath.factorial(x.re.intValueExact()).round(mathContext));
        }
        MathContext mc = new MathContext(mathContext.getPrecision() * 2, mathContext.getRoundingMode());
        int a = mathContext.getPrecision() * 13 / 10;
        List<BigDecimal> constants = BigDecimalMath.getSpougeFactorialConstants(a);
        BigDecimal bigA = BigDecimal.valueOf(a);
        boolean negative = false;
        BigComplex factor = BigComplex.valueOf(constants.get(0));
        for (int k = 1; k < a; ++k) {
            BigDecimal bigK = BigDecimal.valueOf(k);
            factor = factor.add(BigComplex.valueOf(constants.get(k)).divide(x.add(bigK), mc), mc);
            negative = !negative;
        }
        BigComplex result = BigComplexMath.pow(x.add(bigA, mc), x.add(BigDecimal.valueOf(0.5), mc), mc);
        result = result.multiply(BigComplexMath.exp(x.negate().subtract(bigA, mc), mc), mc);
        result = result.multiply(factor, mc);
        return result.round(mathContext);
    }

    public static BigComplex gamma(BigComplex x, MathContext mathContext) {
        return BigComplexMath.factorial(x.subtract(BigComplex.ONE), mathContext);
    }

    public static BigComplex exp(BigComplex x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        BigDecimal expRe = BigDecimalMath.exp(x.re, mc);
        return BigComplex.valueOf(expRe.multiply(BigDecimalMath.cos(x.im, mc), mc).round(mathContext), expRe.multiply(BigDecimalMath.sin(x.im, mc), mc)).round(mathContext);
    }

    public static BigComplex sin(BigComplex x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        return BigComplex.valueOf(BigDecimalMath.sin(x.re, mc).multiply(BigDecimalMath.cosh(x.im, mc), mc).round(mathContext), BigDecimalMath.cos(x.re, mc).multiply(BigDecimalMath.sinh(x.im, mc), mc).round(mathContext));
    }

    public static BigComplex cos(BigComplex x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        return BigComplex.valueOf(BigDecimalMath.cos(x.re, mc).multiply(BigDecimalMath.cosh(x.im, mc), mc).round(mathContext), BigDecimalMath.sin(x.re, mc).multiply(BigDecimalMath.sinh(x.im, mc), mc).negate().round(mathContext));
    }

    public static BigComplex tan(BigComplex x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        return BigComplexMath.sin(x, mc).divide(BigComplexMath.cos(x, mc), mc).round(mathContext);
    }

    public static BigComplex atan(BigComplex x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        return BigComplexMath.log(BigComplex.I.subtract(x, mc).divide(BigComplex.I.add(x, mc), mc), mc).divide(BigComplex.I, mc).divide(TWO, mc).round(mathContext);
    }

    public static BigComplex acot(BigComplex x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        return BigComplexMath.log(x.add(BigComplex.I, mc).divide(x.subtract(BigComplex.I, mc), mc), mc).divide(BigComplex.I, mc).divide(TWO, mc).round(mathContext);
    }

    public static BigComplex asin(BigComplex x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        return BigComplex.I.negate().multiply(BigComplexMath.log(BigComplex.I.multiply(x, mc).add(BigComplexMath.sqrt(BigComplex.ONE.subtract(x.multiply(x, mc), mc), mc), mc), mc), mc).round(mathContext);
    }

    public static BigComplex acos(BigComplex x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        return BigComplex.I.negate().multiply(BigComplexMath.log(x.add(BigComplexMath.sqrt(x.multiply(x, mc).subtract(BigComplex.ONE, mc), mc), mc), mc), mc).round(mathContext);
    }

    public static BigComplex sqrt(BigComplex x, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        BigDecimal magnitude = x.abs(mc);
        BigComplex a = x.add(magnitude, mc);
        return a.divide(a.abs(mc), mc).multiply(BigDecimalMath.sqrt(magnitude, mc), mc).round(mathContext);
    }

    public static BigComplex log(BigComplex x, MathContext mathContext) {
        MathContext mc1 = new MathContext(mathContext.getPrecision() + 20, mathContext.getRoundingMode());
        MathContext mc2 = new MathContext(mathContext.getPrecision() + 5, mathContext.getRoundingMode());
        return BigComplex.valueOf(BigDecimalMath.log(x.abs(mc1), mc1).round(mathContext), x.angle(mc2)).round(mathContext);
    }

    public static BigComplex pow(BigComplex x, long y, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 10, mathContext.getRoundingMode());
        if (y < 0L) {
            return BigComplex.ONE.divide(BigComplexMath.pow(x, -y, mc), mc).round(mathContext);
        }
        BigComplex result = BigComplex.ONE;
        while (y > 0L) {
            if ((y & 1L) == 1L) {
                result = result.multiply(x, mc);
                --y;
            }
            if (y > 0L) {
                x = x.multiply(x, mc);
            }
            y >>= 1;
        }
        return result.round(mathContext);
    }

    public static BigComplex pow(BigComplex x, BigDecimal y, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        BigDecimal angleTimesN = x.angle(mc).multiply(y, mc);
        return BigComplex.valueOf(BigDecimalMath.cos(angleTimesN, mc), BigDecimalMath.sin(angleTimesN, mc)).multiply(BigDecimalMath.pow(x.abs(mc), y, mc), mc).round(mathContext);
    }

    public static BigComplex pow(BigComplex x, BigComplex y, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        return BigComplexMath.exp(y.multiply(BigComplexMath.log(x, mc), mc), mc).round(mathContext);
    }

    public static BigComplex root(BigComplex x, BigDecimal n, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        return BigComplexMath.pow(x, BigDecimal.ONE.divide(n, mc), mc).round(mathContext);
    }

    public static BigComplex root(BigComplex x, BigComplex n, MathContext mathContext) {
        MathContext mc = new MathContext(mathContext.getPrecision() + 4, mathContext.getRoundingMode());
        return BigComplexMath.pow(x, BigComplex.ONE.divide(n, mc), mc).round(mathContext);
    }
}

