/*
 * Decompiled with CFR 0.152.
 */
package ch.acanda.maven.springbanner;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.stream.Stream;

public class RootPath
implements AutoCloseable {
    private FileSystem fileSystem;

    public Stream<Path> walkReadableFiles(Class<?> resourceClass, String extension) throws IOException, URISyntaxException {
        return Files.walk(this.getRootResource(resourceClass), 1, new FileVisitOption[0]).filter(path -> this.isReadableFont((Path)path, extension));
    }

    @Override
    public void close() throws IOException {
        if (this.fileSystem != null) {
            this.fileSystem.close();
        }
    }

    private Path getRootResource(Class<?> resourceClass) throws IOException, URISyntaxException {
        URI uri = resourceClass.getResource("/standard.flf").toURI();
        if ("jar".equals(uri.getScheme())) {
            this.fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
            return this.fileSystem.getPath("/", new String[0]);
        }
        return Paths.get(uri).getParent();
    }

    private boolean isReadableFont(Path path, String extension) {
        return path.toString().endsWith(extension) && Files.isReadable(path) && Files.isRegularFile(path, new LinkOption[0]);
    }
}

