/*
 * Decompiled with CFR 0.152.
 */
package ch.acanda.maven.springbanner;

import ch.acanda.maven.springbanner.Color;
import ch.acanda.maven.springbanner.RootPath;
import ch.acanda.maven.springbanner.Whitespace;
import com.github.dtmo.jfiglet.FigFont;
import com.github.dtmo.jfiglet.FigFontResources;
import com.github.dtmo.jfiglet.FigletRenderer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class GenerateMojo
extends AbstractMojo {
    public static final String TEXT_DEFAULT_VALUE = "${project.name}";
    public static final String OUTPUT_DIRECTORY_DEFAULT_VALUE = "${project.build.outputDirectory}";
    public static final String FILENAME_DEFAULT_VALUE = "banner.txt";
    public static final String INCLUDE_INFO_DEFAULT_VALUE = "true";
    public static final String COLOR_DEFAULT_VALUE = "default";
    public static final String FONT_DEFAULT_VALUE = "standard";
    public static final String INFO_DEFAULT_VALUE = "Version: ${application.version:${project.version}}, Server: ${server.address:localhost}:${server.port:8080}, Active Profiles: ${spring.profiles.active:none}";
    private static final String FONT_PREFIX_FILE = "file:";
    @Parameter(defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="banner.text", required=true, defaultValue="${project.name}")
    private String text;
    @Parameter(property="banner.outputDirectory", required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(property="banner.filename", required=true, defaultValue="banner.txt")
    private String filename;
    @Parameter(property="banner.includeInfo", defaultValue="true")
    private boolean includeInfo;
    @Parameter(property="banner.info", defaultValue="Version: ${application.version:${project.version}}, Server: ${server.address:localhost}:${server.port:8080}, Active Profiles: ${spring.profiles.active:none}")
    private String info;
    @Parameter(property="banner.font", defaultValue="standard")
    private String font;
    @Parameter(property="banner.color", defaultValue="default")
    private String color;

    public GenerateMojo() {
    }

    public GenerateMojo(MavenProject project, String text, File outputDirectory, String filename, boolean includeInfo, String info, String font, String color) {
        this.project = project;
        this.text = text;
        this.outputDirectory = outputDirectory;
        this.filename = filename;
        this.includeInfo = includeInfo;
        this.info = info;
        this.font = font;
        this.color = color == null ? Color.DEFAULT.name() : color;
    }

    public void execute() throws MojoFailureException {
        try {
            this.getLog().info((CharSequence)"Generating Spring Boot banner...");
            String banner = this.generateBanner();
            this.writeBannerFile(banner);
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private String generateBanner() throws MojoFailureException {
        FigletRenderer renderer = new FigletRenderer(this.getFont());
        String rawBanner = renderer.renderText(this.text);
        String[] lines = Whitespace.strip(rawBanner);
        StringBuilder banner = new StringBuilder(32);
        boolean isDefaultColor = Color.DEFAULT.getTagValue().equals(this.color);
        for (String line : lines) {
            banner.append('\n');
            if (!isDefaultColor) {
                Color.nameFromTagValue(this.color).ifPresent(name -> banner.append("${AnsiColor.").append(name).append('}'));
            }
            banner.append(line);
        }
        if (!isDefaultColor) {
            banner.append("${AnsiColor.DEFAULT}");
        }
        if (this.includeInfo) {
            this.info = this.info == null ? null : this.info.replaceAll("\\$\\{project\\.version}", this.project.getVersion());
            banner.append('\n').append(this.info);
        }
        banner.append('\n');
        this.getLog().debug((CharSequence)("\n" + banner.toString()));
        return banner.toString();
    }

    private FigFont getFont() throws MojoFailureException {
        if (this.font.startsWith(FONT_PREFIX_FILE)) {
            FigFont figFont;
            block12: {
                Path path = Paths.get(this.font.substring(FONT_PREFIX_FILE.length()), new String[0]);
                InputStream stream = Files.newInputStream(path, new OpenOption[0]);
                try {
                    figFont = FigFont.loadFigFont((InputStream)stream);
                    if (stream == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new MojoFailureException("Font file " + path + " does not exist.", (Throwable)e);
                    }
                }
                stream.close();
            }
            return figFont;
        }
        List<String> buildInFonts = this.getBuildInFonts();
        if (buildInFonts.contains(this.font)) {
            try {
                return FigFontResources.loadFigFontResource((String)(this.font + ".flf"));
            }
            catch (IOException e) {
                throw this.createMissingFontException(buildInFonts, e);
            }
        }
        throw this.createMissingFontException(buildInFonts, null);
    }

    private List<String> getBuildInFonts() throws MojoFailureException {
        List<String> list;
        RootPath rootPath = new RootPath();
        try {
            list = rootPath.walkReadableFiles(FigFontResources.class, ".flf").map(path -> path.getFileName().toString()).map(name -> name.substring(0, name.length() - 4)).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    rootPath.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | URISyntaxException e) {
                throw new MojoFailureException("Cannot collect names of build-in fonts.", (Throwable)e);
            }
        }
        rootPath.close();
        return list;
    }

    private MojoFailureException createMissingFontException(List<String> buildInFonts, Throwable cause) {
        String msg = "The built-in font \"%s\" does not exist. Available fonts: %s.";
        String fonts = buildInFonts.stream().sorted().collect(Collectors.joining(", "));
        return new MojoFailureException(String.format("The built-in font \"%s\" does not exist. Available fonts: %s.", this.font, fonts), cause);
    }

    private void writeBannerFile(String banner) throws IOException {
        Path bannerFile = this.outputDirectory.toPath().resolve(this.filename);
        this.getLog().debug((CharSequence)("Writing banner to file " + bannerFile));
        if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            throw new IOException("Failed to create output directory " + this.outputDirectory);
        }
        Files.write(bannerFile, banner.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }
}

