/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.group.RGV_O15_ORDER;
import ca.uhn.hl7v2.model.v251.group.RGV_O15_PATIENT;
import ca.uhn.hl7v2.model.v251.segment.MSH;
import ca.uhn.hl7v2.model.v251.segment.NTE;
import ca.uhn.hl7v2.model.v251.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RGV_O15
extends AbstractMessage {
    public RGV_O15() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public RGV_O15(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(NTE.class, false, true);
            this.add(RGV_O15_PATIENT.class, false, false);
            this.add(RGV_O15_ORDER.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RGV_O15 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public NTE getNTE() {
        return (NTE)this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return (NTE)this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public RGV_O15_PATIENT getPATIENT() {
        return (RGV_O15_PATIENT)this.getTyped("PATIENT", RGV_O15_PATIENT.class);
    }

    public RGV_O15_ORDER getORDER() {
        return (RGV_O15_ORDER)this.getTyped("ORDER", RGV_O15_ORDER.class);
    }

    public RGV_O15_ORDER getORDER(int rep) {
        return (RGV_O15_ORDER)this.getTyped("ORDER", rep, RGV_O15_ORDER.class);
    }

    public int getORDERReps() {
        return this.getReps("ORDER");
    }

    public List<RGV_O15_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", RGV_O15_ORDER.class);
    }

    public void insertORDER(RGV_O15_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", (Structure)structure, rep);
    }

    public RGV_O15_ORDER insertORDER(int rep) throws HL7Exception {
        return (RGV_O15_ORDER)super.insertRepetition("ORDER", rep);
    }

    public RGV_O15_ORDER removeORDER(int rep) throws HL7Exception {
        return (RGV_O15_ORDER)super.removeRepetition("ORDER", rep);
    }
}

