/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.group.PPP_PCB_PATHWAY;
import ca.uhn.hl7v2.model.v251.group.PPP_PCB_PATIENT_VISIT;
import ca.uhn.hl7v2.model.v251.segment.MSH;
import ca.uhn.hl7v2.model.v251.segment.PID;
import ca.uhn.hl7v2.model.v251.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class PPP_PCB
extends AbstractMessage {
    public PPP_PCB() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public PPP_PCB(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(PID.class, true, false);
            this.add(PPP_PCB_PATIENT_VISIT.class, false, false);
            this.add(PPP_PCB_PATHWAY.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PPP_PCB - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public PID getPID() {
        return (PID)this.getTyped("PID", PID.class);
    }

    public PPP_PCB_PATIENT_VISIT getPATIENT_VISIT() {
        return (PPP_PCB_PATIENT_VISIT)this.getTyped("PATIENT_VISIT", PPP_PCB_PATIENT_VISIT.class);
    }

    public PPP_PCB_PATHWAY getPATHWAY() {
        return (PPP_PCB_PATHWAY)this.getTyped("PATHWAY", PPP_PCB_PATHWAY.class);
    }

    public PPP_PCB_PATHWAY getPATHWAY(int rep) {
        return (PPP_PCB_PATHWAY)this.getTyped("PATHWAY", rep, PPP_PCB_PATHWAY.class);
    }

    public int getPATHWAYReps() {
        return this.getReps("PATHWAY");
    }

    public List<PPP_PCB_PATHWAY> getPATHWAYAll() throws HL7Exception {
        return this.getAllAsList("PATHWAY", PPP_PCB_PATHWAY.class);
    }

    public void insertPATHWAY(PPP_PCB_PATHWAY structure, int rep) throws HL7Exception {
        super.insertRepetition("PATHWAY", (Structure)structure, rep);
    }

    public PPP_PCB_PATHWAY insertPATHWAY(int rep) throws HL7Exception {
        return (PPP_PCB_PATHWAY)super.insertRepetition("PATHWAY", rep);
    }

    public PPP_PCB_PATHWAY removePATHWAY(int rep) throws HL7Exception {
        return (PPP_PCB_PATHWAY)super.removeRepetition("PATHWAY", rep);
    }
}

