/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.segment.CTD;
import ca.uhn.hl7v2.model.v251.segment.PRD;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RPI_I04_PROVIDER
extends AbstractGroup {
    public RPI_I04_PROVIDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PRD.class, true, false, false);
            this.add(CTD.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RPI_I04_PROVIDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public PRD getPRD() {
        PRD retVal = (PRD)this.getTyped("PRD", PRD.class);
        return retVal;
    }

    public CTD getCTD() {
        CTD retVal = (CTD)this.getTyped("CTD", CTD.class);
        return retVal;
    }

    public CTD getCTD(int rep) {
        CTD retVal = (CTD)this.getTyped("CTD", rep, CTD.class);
        return retVal;
    }

    public int getCTDReps() {
        return this.getReps("CTD");
    }

    public List<CTD> getCTDAll() throws HL7Exception {
        return this.getAllAsList("CTD", CTD.class);
    }

    public void insertCTD(CTD structure, int rep) throws HL7Exception {
        super.insertRepetition("CTD", (Structure)structure, rep);
    }

    public CTD insertCTD(int rep) throws HL7Exception {
        return (CTD)super.insertRepetition("CTD", rep);
    }

    public CTD removeCTD(int rep) throws HL7Exception {
        return (CTD)super.removeRepetition("CTD", rep);
    }
}

