/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.group.MFN_M01_MF;
import ca.uhn.hl7v2.model.v251.segment.MFI;
import ca.uhn.hl7v2.model.v251.segment.MSH;
import ca.uhn.hl7v2.model.v251.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MFN_M01
extends AbstractMessage {
    public MFN_M01() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public MFN_M01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(MFI.class, true, false);
            this.add(MFN_M01_MF.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFN_M01 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public MFI getMFI() {
        return (MFI)this.getTyped("MFI", MFI.class);
    }

    public MFN_M01_MF getMF() {
        return (MFN_M01_MF)this.getTyped("MF", MFN_M01_MF.class);
    }

    public MFN_M01_MF getMF(int rep) {
        return (MFN_M01_MF)this.getTyped("MF", rep, MFN_M01_MF.class);
    }

    public int getMFReps() {
        return this.getReps("MF");
    }

    public List<MFN_M01_MF> getMFAll() throws HL7Exception {
        return this.getAllAsList("MF", MFN_M01_MF.class);
    }

    public void insertMF(MFN_M01_MF structure, int rep) throws HL7Exception {
        super.insertRepetition("MF", (Structure)structure, rep);
    }

    public MFN_M01_MF insertMF(int rep) throws HL7Exception {
        return (MFN_M01_MF)super.insertRepetition("MF", rep);
    }

    public MFN_M01_MF removeMF(int rep) throws HL7Exception {
        return (MFN_M01_MF)super.removeRepetition("MF", rep);
    }
}

