/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.group.MDM_T01_TIMING;
import ca.uhn.hl7v2.model.v251.segment.NTE;
import ca.uhn.hl7v2.model.v251.segment.OBR;
import ca.uhn.hl7v2.model.v251.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MDM_T01_COMMON_ORDER
extends AbstractGroup {
    public MDM_T01_COMMON_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(MDM_T01_TIMING.class, false, true, false);
            this.add(OBR.class, true, false, false);
            this.add(NTE.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MDM_T01_COMMON_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public ORC getORC() {
        ORC retVal = (ORC)this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public MDM_T01_TIMING getTIMING() {
        MDM_T01_TIMING retVal = (MDM_T01_TIMING)this.getTyped("TIMING", MDM_T01_TIMING.class);
        return retVal;
    }

    public MDM_T01_TIMING getTIMING(int rep) {
        MDM_T01_TIMING retVal = (MDM_T01_TIMING)this.getTyped("TIMING", rep, MDM_T01_TIMING.class);
        return retVal;
    }

    public int getTIMINGReps() {
        return this.getReps("TIMING");
    }

    public List<MDM_T01_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", MDM_T01_TIMING.class);
    }

    public void insertTIMING(MDM_T01_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", (Structure)structure, rep);
    }

    public MDM_T01_TIMING insertTIMING(int rep) throws HL7Exception {
        return (MDM_T01_TIMING)super.insertRepetition("TIMING", rep);
    }

    public MDM_T01_TIMING removeTIMING(int rep) throws HL7Exception {
        return (MDM_T01_TIMING)super.removeRepetition("TIMING", rep);
    }

    public OBR getOBR() {
        OBR retVal = (OBR)this.getTyped("OBR", OBR.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }
}

