/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.utils;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.client.FeedFormat;
import org.hl7.fhir.instance.client.IFHIRClient;
import org.hl7.fhir.instance.client.ResourceFormat;
import org.hl7.fhir.instance.model.Bundle;
import org.hl7.fhir.instance.model.ConceptMap;
import org.hl7.fhir.instance.model.Conformance;
import org.hl7.fhir.instance.model.DataElement;
import org.hl7.fhir.instance.model.ElementDefinition;
import org.hl7.fhir.instance.model.OperationOutcome;
import org.hl7.fhir.instance.model.Parameters;
import org.hl7.fhir.instance.model.Questionnaire;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.SearchParameter;
import org.hl7.fhir.instance.model.StructureDefinition;
import org.hl7.fhir.instance.model.ValueSet;
import org.hl7.fhir.instance.terminologies.ITerminologyServices;
import org.hl7.fhir.instance.terminologies.ValueSetExpander;
import org.hl7.fhir.instance.utils.NameResolver;

public class WorkerContext
implements NameResolver {
    private ITerminologyServices terminologyServices = new NullTerminologyServices();
    private IFHIRClient client = new NullClient();
    private Map<String, ValueSet> codeSystems = new HashMap<String, ValueSet>();
    private Map<String, DataElement> dataElements = new HashMap<String, DataElement>();
    private Map<String, ValueSet> valueSets = new HashMap<String, ValueSet>();
    private Map<String, ConceptMap> maps = new HashMap<String, ConceptMap>();
    private Map<String, StructureDefinition> profiles = new HashMap<String, StructureDefinition>();
    private Map<String, SearchParameter> searchParameters = new HashMap<String, SearchParameter>();
    private Map<String, StructureDefinition> extensionDefinitions = new HashMap<String, StructureDefinition>();
    private String version;
    private List<String> resourceNames = new ArrayList<String>();
    private Map<String, Questionnaire> questionnaires = new HashMap<String, Questionnaire>();

    public WorkerContext() {
    }

    public WorkerContext(ITerminologyServices conceptLocator, IFHIRClient client, Map<String, ValueSet> codeSystems, Map<String, ValueSet> valueSets, Map<String, ConceptMap> maps, Map<String, StructureDefinition> profiles) {
        if (conceptLocator != null) {
            this.terminologyServices = conceptLocator;
        }
        if (client != null) {
            this.client = client;
        }
        if (codeSystems != null) {
            this.codeSystems = codeSystems;
        }
        if (valueSets != null) {
            this.valueSets = valueSets;
        }
        if (maps != null) {
            this.maps = maps;
        }
        if (profiles != null) {
            this.profiles = profiles;
        }
    }

    public ITerminologyServices getTerminologyServices() {
        return this.terminologyServices;
    }

    public boolean hasClient() {
        return this.client != null && !(this.client instanceof NullClient);
    }

    public IFHIRClient getClient() {
        return this.client;
    }

    public Map<String, ValueSet> getCodeSystems() {
        return this.codeSystems;
    }

    public Map<String, DataElement> getDataElements() {
        return this.dataElements;
    }

    public Map<String, ValueSet> getValueSets() {
        return this.valueSets;
    }

    public Map<String, ConceptMap> getMaps() {
        return this.maps;
    }

    public StructureDefinition getProfile(String theId) {
        return this.profiles.get(theId);
    }

    @Deprecated
    public Map<String, StructureDefinition> getProfiles() {
        return this.profiles;
    }

    public Map<String, StructureDefinition> getExtensionDefinitions() {
        return this.extensionDefinitions;
    }

    public Map<String, Questionnaire> getQuestionnaires() {
        return this.questionnaires;
    }

    public WorkerContext setTerminologyServices(ITerminologyServices terminologyServices) {
        this.terminologyServices = terminologyServices;
        return this;
    }

    public WorkerContext clone(IFHIRClient altClient) {
        WorkerContext res = new WorkerContext(this.terminologyServices, null, this.codeSystems, this.valueSets, this.maps, this.profiles);
        res.extensionDefinitions.putAll(this.extensionDefinitions);
        res.version = this.version;
        res.client = altClient;
        return res;
    }

    public void seeExtensionDefinition(String url, StructureDefinition ed) throws Exception {
        if (this.extensionDefinitions.get(ed.getUrl()) != null) {
            throw new Exception("duplicate extension definition: " + ed.getUrl());
        }
        this.extensionDefinitions.put(ed.getId(), ed);
        this.extensionDefinitions.put(url, ed);
        this.extensionDefinitions.put(ed.getUrl(), ed);
    }

    public void seeQuestionnaire(String url, Questionnaire theQuestionnaire) throws Exception {
        if (this.questionnaires.get(theQuestionnaire.getId()) != null) {
            throw new Exception("duplicate extension definition: " + theQuestionnaire.getId());
        }
        this.questionnaires.put(theQuestionnaire.getId(), theQuestionnaire);
        this.questionnaires.put(url, theQuestionnaire);
    }

    public void seeValueSet(String url, ValueSet vs) throws Exception {
        if (this.valueSets.containsKey(vs.getUrl())) {
            throw new Exception("Duplicate Profile " + vs.getUrl());
        }
        this.valueSets.put(vs.getId(), vs);
        this.valueSets.put(url, vs);
        this.valueSets.put(vs.getUrl(), vs);
        if (vs.hasCodeSystem()) {
            this.codeSystems.put(vs.getCodeSystem().getSystem().toString(), vs);
        }
    }

    public void seeProfile(String url, StructureDefinition p) {
        if (this.profiles.containsKey(p.getUrl())) {
            throw new IllegalArgumentException("Duplicate Profile " + p.getUrl());
        }
        this.profiles.put(p.getId(), p);
        this.profiles.put(url, p);
        this.profiles.put(p.getUrl(), p);
    }

    public StructureDefinition getExtensionStructure(StructureDefinition context, String url) throws Exception {
        StructureDefinition res;
        if (url.startsWith("#")) {
            throw new Error("Contained extensions not done yet");
        }
        if (url.contains("#")) {
            url = url.substring(0, url.indexOf("#"));
        }
        if ((res = this.extensionDefinitions.get(url)) == null) {
            res = this.profiles.get(url);
        }
        if (res == null) {
            return null;
        }
        if (res.getSnapshot() == null || res.getSnapshot().getElement().isEmpty()) {
            throw new Exception("no snapshot on extension for url " + url);
        }
        return res;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public boolean isResource(String name) {
        if (this.resourceNames.contains(name)) {
            return true;
        }
        StructureDefinition sd = this.profiles.get("http://hl7.org/fhir/StructureDefinition/" + name);
        return sd != null && (sd.getBase().endsWith("Resource") || sd.getBase().endsWith("DomainResource"));
    }

    public List<String> getResourceNames() {
        return this.resourceNames;
    }

    public StructureDefinition getTypeStructure(ElementDefinition.TypeRefComponent type) {
        if (type.hasProfile()) {
            return this.profiles.get(type.getProfile().get(0).getValue());
        }
        return this.profiles.get(type.getCode());
    }

    public Map<String, SearchParameter> getSearchParameters() {
        return this.searchParameters;
    }

    public class NullTerminologyServices
    implements ITerminologyServices {
        @Override
        public boolean supportsSystem(String system) {
            return false;
        }

        @Override
        public ValueSet.ConceptDefinitionComponent getCodeDefinition(String system, String code) {
            throw new Error("call to NullTerminologyServices");
        }

        @Override
        public ITerminologyServices.ValidationResult validateCode(String system, String code, String display) {
            throw new Error("call to NullTerminologyServices");
        }

        @Override
        public ValueSet.ValueSetExpansionComponent expandVS(ValueSet.ConceptSetComponent inc) throws Exception {
            throw new Error("call to NullTerminologyServices");
        }

        @Override
        public boolean checkVS(ValueSet.ConceptSetComponent vsi, String system, String code) {
            throw new Error("call to NullTerminologyServices");
        }

        @Override
        public boolean verifiesSystem(String system) {
            return false;
        }

        @Override
        public ValueSetExpander.ValueSetExpansionOutcome expand(ValueSet vs) {
            throw new Error("call to NullTerminologyServices");
        }
    }

    public class NullClient
    implements IFHIRClient {
        @Override
        public IFHIRClient.VersionInfo getVersions() {
            throw new Error("call to NullClient");
        }

        @Override
        public IFHIRClient initialize(String baseServiceUrl) throws URISyntaxException {
            throw new Error("call to NullClient");
        }

        @Override
        public void initialize(String baseServiceUrl, int recordCount) throws URISyntaxException {
            throw new Error("call to NullClient");
        }

        @Override
        public void setPreferredResourceFormat(ResourceFormat resourceFormat) {
            throw new Error("call to NullClient");
        }

        @Override
        public String getPreferredResourceFormat() {
            throw new Error("call to NullClient");
        }

        @Override
        public void setPreferredFeedFormat(FeedFormat feedFormat) {
            throw new Error("call to NullClient");
        }

        @Override
        public String getPreferredFeedFormat() {
            throw new Error("call to NullClient");
        }

        @Override
        public int getMaximumRecordCount() {
            throw new Error("call to NullClient");
        }

        @Override
        public void setMaximumRecordCount(int recordCount) {
            throw new Error("call to NullClient");
        }

        @Override
        public Conformance getConformanceStatement() {
            throw new Error("call to NullClient");
        }

        @Override
        public Conformance getConformanceStatement(boolean useOptionsVerb) {
            throw new Error("call to NullClient");
        }

        @Override
        public <T extends Resource> T read(Class<T> resource, String id) {
            throw new Error("call to NullClient");
        }

        @Override
        public <T extends Resource> T vread(Class<T> resource, String id, String versionid) {
            throw new Error("call to NullClient");
        }

        @Override
        public <T extends Resource> T update(Class<T> resourceClass, T resource, String id) {
            throw new Error("call to NullClient");
        }

        @Override
        public <T extends Resource> boolean delete(Class<T> resourceClass, String id) {
            throw new Error("call to NullClient");
        }

        @Override
        public <T extends Resource> OperationOutcome create(Class<T> resourceClass, T resource) {
            throw new Error("call to NullClient");
        }

        @Override
        public <T extends Resource> Bundle history(Calendar lastUpdate, Class<T> resourceClass, String id) {
            throw new Error("call to NullClient");
        }

        @Override
        public <T extends Resource> Bundle history(Date lastUpdate, Class<T> resourceClass, String id) {
            throw new Error("call to NullClient");
        }

        @Override
        public <T extends Resource> Bundle history(Class<T> resource, String id) {
            throw new Error("call to NullClient");
        }

        @Override
        public <T extends Resource> Bundle history(Calendar lastUpdate, Class<T> resourceClass) {
            throw new Error("call to NullClient");
        }

        @Override
        public <T extends Resource> Bundle history(Date lastUpdate, Class<T> resourceClass) {
            throw new Error("call to NullClient");
        }

        @Override
        public <T extends Resource> Bundle history(Class<T> resourceClass) {
            throw new Error("call to NullClient");
        }

        @Override
        public <T extends Resource> Bundle history(Calendar lastUpdate) {
            throw new Error("call to NullClient");
        }

        @Override
        public <T extends Resource> Bundle history(Date lastUpdate) {
            throw new Error("call to NullClient");
        }

        @Override
        public <T extends Resource> Bundle history() {
            throw new Error("call to NullClient");
        }

        @Override
        public <T extends Resource> OperationOutcome validate(Class<T> resourceClass, T resource, String id) {
            throw new Error("call to NullClient");
        }

        @Override
        public <T extends Resource> Bundle search(Class<T> resourceClass, Map<String, String> params) {
            throw new Error("call to NullClient");
        }

        @Override
        public <T extends Resource> Bundle searchPost(Class<T> resourceClass, T resource, Map<String, String> params) {
            throw new Error("call to NullClient");
        }

        @Override
        public Bundle transaction(Bundle batch) {
            throw new Error("call to NullClient");
        }

        @Override
        public Bundle fetchFeed(String url) {
            throw new Error("call to NullClient");
        }

        @Override
        public ValueSet expandValueset(ValueSet source) throws Exception {
            throw new Error("call to NullClient");
        }

        @Override
        public <T extends Resource> Parameters operateType(Class<T> resourceClass, String name, Parameters params) {
            throw new Error("call to NullClient");
        }

        @Override
        public Conformance getConformanceStatementQuick() {
            throw new Error("call to NullClient");
        }

        @Override
        public Conformance getConformanceStatementQuick(boolean useOptionsVerb) {
            throw new Error("call to NullClient");
        }

        @Override
        public String getAddress() {
            throw new Error("call to NullClient");
        }
    }
}

