/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum VaccinationProtocolDoseTarget {
    CRS,
    DIP,
    MEA,
    MUM,
    RUB,
    TET,
    HIB,
    PER,
    POL,
    NULL;


    public static VaccinationProtocolDoseTarget fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("crs".equals(codeString)) {
            return CRS;
        }
        if ("dip".equals(codeString)) {
            return DIP;
        }
        if ("mea".equals(codeString)) {
            return MEA;
        }
        if ("mum".equals(codeString)) {
            return MUM;
        }
        if ("rub".equals(codeString)) {
            return RUB;
        }
        if ("tet".equals(codeString)) {
            return TET;
        }
        if ("hib".equals(codeString)) {
            return HIB;
        }
        if ("per".equals(codeString)) {
            return PER;
        }
        if ("pol".equals(codeString)) {
            return POL;
        }
        throw new Exception("Unknown VaccinationProtocolDoseTarget code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case CRS: {
                return "crs";
            }
            case DIP: {
                return "dip";
            }
            case MEA: {
                return "mea";
            }
            case MUM: {
                return "mum";
            }
            case RUB: {
                return "rub";
            }
            case TET: {
                return "tet";
            }
            case HIB: {
                return "hib";
            }
            case PER: {
                return "per";
            }
            case POL: {
                return "pol";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/vaccination-protocol-dose-target";
    }

    public String getDefinition() {
        switch (this) {
            case CRS: {
                return "";
            }
            case DIP: {
                return "";
            }
            case MEA: {
                return "";
            }
            case MUM: {
                return "";
            }
            case RUB: {
                return "";
            }
            case TET: {
                return "";
            }
            case HIB: {
                return "";
            }
            case PER: {
                return "";
            }
            case POL: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case CRS: {
                return "Congenital Rubella Syndrome";
            }
            case DIP: {
                return "Diptheria";
            }
            case MEA: {
                return "Measles";
            }
            case MUM: {
                return "Mumps";
            }
            case RUB: {
                return "Rubella";
            }
            case TET: {
                return "Tetanus";
            }
            case HIB: {
                return "Haemophilus influenzae type b";
            }
            case PER: {
                return "Pertussis";
            }
            case POL: {
                return "Poliomyelitis";
            }
        }
        return "?";
    }
}

