/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum V3ActInvoiceElementModifier {
    EFORM,
    FAX,
    LINV,
    PAPER,
    NULL;


    public static V3ActInvoiceElementModifier fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("EFORM".equals(codeString)) {
            return EFORM;
        }
        if ("FAX".equals(codeString)) {
            return FAX;
        }
        if ("LINV".equals(codeString)) {
            return LINV;
        }
        if ("PAPER".equals(codeString)) {
            return PAPER;
        }
        throw new Exception("Unknown V3ActInvoiceElementModifier code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case EFORM: {
                return "EFORM";
            }
            case FAX: {
                return "FAX";
            }
            case LINV: {
                return "LINV";
            }
            case PAPER: {
                return "PAPER";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/v3/ActInvoiceElementModifier";
    }

    public String getDefinition() {
        switch (this) {
            case EFORM: {
                return "Electronic form with supporting information to follow.";
            }
            case FAX: {
                return "Fax with supporting information to follow.";
            }
            case LINV: {
                return "Represents the last invoice from the perspective of the provider.";
            }
            case PAPER: {
                return "Paper documentation (or other physical format) with supporting information to follow.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case EFORM: {
                return "Electronic Form To Follow";
            }
            case FAX: {
                return "Fax To Follow";
            }
            case LINV: {
                return "Last Invoice";
            }
            case PAPER: {
                return "Paper Documentation To Follow";
            }
        }
        return "?";
    }
}

