/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum V3ActExposureLevelCode {
    _ACTEXPOSURELEVELCODE,
    HIGH,
    LOW,
    MEDIUM,
    NULL;


    public static V3ActExposureLevelCode fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("_ActExposureLevelCode".equals(codeString)) {
            return _ACTEXPOSURELEVELCODE;
        }
        if ("HIGH".equals(codeString)) {
            return HIGH;
        }
        if ("LOW".equals(codeString)) {
            return LOW;
        }
        if ("MEDIUM".equals(codeString)) {
            return MEDIUM;
        }
        throw new Exception("Unknown V3ActExposureLevelCode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case _ACTEXPOSURELEVELCODE: {
                return "_ActExposureLevelCode";
            }
            case HIGH: {
                return "HIGH";
            }
            case LOW: {
                return "LOW";
            }
            case MEDIUM: {
                return "MEDIUM";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/v3/ActExposureLevelCode";
    }

    public String getDefinition() {
        switch (this) {
            case _ACTEXPOSURELEVELCODE: {
                return "A qualitative measure of the degree of exposure to the causative agent.  This includes concepts such as \"low\", \"medium\" and \"high\".  This quantifies how the quantity that was available to be administered to the target differs from typical or background levels of the substance.";
            }
            case HIGH: {
                return "Description: Exposure to an agent at a relatively high level above background.";
            }
            case LOW: {
                return "Description: Exposure to an agent at a relatively low level above background.";
            }
            case MEDIUM: {
                return "Description: Exposure to an agent at a relatively moderate level above background.A";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case _ACTEXPOSURELEVELCODE: {
                return "ActExposureLevelCode";
            }
            case HIGH: {
                return "high";
            }
            case LOW: {
                return "low";
            }
            case MEDIUM: {
                return "medium";
            }
        }
        return "?";
    }
}

