/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum TransactionProcessingMode {
    IGNORE,
    UPDATE,
    DELETE,
    NULL;


    public static TransactionProcessingMode fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("ignore".equals(codeString)) {
            return IGNORE;
        }
        if ("update".equals(codeString)) {
            return UPDATE;
        }
        if ("delete".equals(codeString)) {
            return DELETE;
        }
        throw new Exception("Unknown TransactionProcessingMode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case IGNORE: {
                return "ignore";
            }
            case UPDATE: {
                return "update";
            }
            case DELETE: {
                return "delete";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/transaction-processing-mode";
    }

    public String getDefinition() {
        switch (this) {
            case IGNORE: {
                return "If a matching resource is found, then ignore the resource and do not process it as part of the transaction (and return the matching resource information in the transaction response)";
            }
            case UPDATE: {
                return "If a matching resource is found, then update it with this resource, otherwise create a new one";
            }
            case DELETE: {
                return "If a resource matching the information provided is found, delete it. If no matching resource is found, the transaction fails";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case IGNORE: {
                return "Ignore";
            }
            case UPDATE: {
                return "Update";
            }
            case DELETE: {
                return "Delete";
            }
        }
        return "?";
    }
}

