/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum SupplyrequestKind {
    CENTRAL,
    NONSTOCK,
    NULL;


    public static SupplyrequestKind fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("central".equals(codeString)) {
            return CENTRAL;
        }
        if ("nonstock".equals(codeString)) {
            return NONSTOCK;
        }
        throw new Exception("Unknown SupplyrequestKind code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case CENTRAL: {
                return "central";
            }
            case NONSTOCK: {
                return "nonstock";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/supply-kind";
    }

    public String getDefinition() {
        switch (this) {
            case CENTRAL: {
                return "Supply is stored and requested from central supply.";
            }
            case NONSTOCK: {
                return "Supply is not onsite and must be requested from an outside vendor using a non-stock requisition.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case CENTRAL: {
                return "Central Supply";
            }
            case NONSTOCK: {
                return "Non-Stock";
            }
        }
        return "?";
    }
}

