/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum ServicePharmacy {
    SMOKECESS,
    FLUSHOT,
    NULL;


    public static ServicePharmacy fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("smokecess".equals(codeString)) {
            return SMOKECESS;
        }
        if ("flushot".equals(codeString)) {
            return FLUSHOT;
        }
        throw new Exception("Unknown ServicePharmacy code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case SMOKECESS: {
                return "smokecess";
            }
            case FLUSHOT: {
                return "flushot";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/ex-pharmaservice";
    }

    public String getDefinition() {
        switch (this) {
            case SMOKECESS: {
                return "Smoking cessation";
            }
            case FLUSHOT: {
                return "Flu Shot";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case SMOKECESS: {
                return "Smoking cessation";
            }
            case FLUSHOT: {
                return "Flu Shot";
            }
        }
        return "?";
    }
}

