/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum ProcessOutcome {
    COMPLETE,
    PENDED,
    ERROR,
    NULL;


    public static ProcessOutcome fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("complete".equals(codeString)) {
            return COMPLETE;
        }
        if ("pended".equals(codeString)) {
            return PENDED;
        }
        if ("error".equals(codeString)) {
            return ERROR;
        }
        throw new Exception("Unknown ProcessOutcome code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case COMPLETE: {
                return "complete";
            }
            case PENDED: {
                return "pended";
            }
            case ERROR: {
                return "error";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/processoutcomecodes";
    }

    public String getDefinition() {
        switch (this) {
            case COMPLETE: {
                return "";
            }
            case PENDED: {
                return "";
            }
            case ERROR: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case COMPLETE: {
                return "complete";
            }
            case PENDED: {
                return "pended";
            }
            case ERROR: {
                return "error";
            }
        }
        return "?";
    }
}

