/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum ProcedureRelationshipType {
    CAUSEDBY,
    BECAUSEOF,
    NULL;


    public static ProcedureRelationshipType fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("caused-by".equals(codeString)) {
            return CAUSEDBY;
        }
        if ("because-of".equals(codeString)) {
            return BECAUSEOF;
        }
        throw new Exception("Unknown ProcedureRelationshipType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case CAUSEDBY: {
                return "caused-by";
            }
            case BECAUSEOF: {
                return "because-of";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/procedure-relationship-type";
    }

    public String getDefinition() {
        switch (this) {
            case CAUSEDBY: {
                return "This procedure had to be performed because of the related one.";
            }
            case BECAUSEOF: {
                return "This procedure caused the related one to be performed.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case CAUSEDBY: {
                return "Caused By";
            }
            case BECAUSEOF: {
                return "Because Of";
            }
        }
        return "?";
    }
}

