/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum PaymentType {
    PAYMENT,
    ADJUSTMENT,
    ADVANCE,
    NULL;


    public static PaymentType fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("payment".equals(codeString)) {
            return PAYMENT;
        }
        if ("adjustment".equals(codeString)) {
            return ADJUSTMENT;
        }
        if ("advance".equals(codeString)) {
            return ADVANCE;
        }
        throw new Exception("Unknown PaymentType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PAYMENT: {
                return "payment";
            }
            case ADJUSTMENT: {
                return "adjustment";
            }
            case ADVANCE: {
                return "advance";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/payment-type";
    }

    public String getDefinition() {
        switch (this) {
            case PAYMENT: {
                return "";
            }
            case ADJUSTMENT: {
                return "";
            }
            case ADVANCE: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PAYMENT: {
                return "payment";
            }
            case ADJUSTMENT: {
                return "adjustment";
            }
            case ADVANCE: {
                return "advance";
            }
        }
        return "?";
    }
}

