/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum Payeetype {
    SUBSCRIBER,
    PROVIDER,
    OTHER,
    NULL;


    public static Payeetype fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("subscriber".equals(codeString)) {
            return SUBSCRIBER;
        }
        if ("provider".equals(codeString)) {
            return PROVIDER;
        }
        if ("other".equals(codeString)) {
            return OTHER;
        }
        throw new Exception("Unknown Payeetype code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case SUBSCRIBER: {
                return "subscriber";
            }
            case PROVIDER: {
                return "provider";
            }
            case OTHER: {
                return "other";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/payeetype";
    }

    public String getDefinition() {
        switch (this) {
            case SUBSCRIBER: {
                return "";
            }
            case PROVIDER: {
                return "";
            }
            case OTHER: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case SUBSCRIBER: {
                return "subscriber";
            }
            case PROVIDER: {
                return "provider";
            }
            case OTHER: {
                return "other";
            }
        }
        return "?";
    }
}

