/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum MissingToothReason {
    E,
    C,
    U,
    O,
    NULL;


    public static MissingToothReason fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("E".equals(codeString)) {
            return E;
        }
        if ("C".equals(codeString)) {
            return C;
        }
        if ("U".equals(codeString)) {
            return U;
        }
        if ("O".equals(codeString)) {
            return O;
        }
        throw new Exception("Unknown MissingToothReason code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case E: {
                return "E";
            }
            case C: {
                return "C";
            }
            case U: {
                return "U";
            }
            case O: {
                return "O";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/missingtoothreason";
    }

    public String getDefinition() {
        switch (this) {
            case E: {
                return "Extraction";
            }
            case C: {
                return "Congenital";
            }
            case U: {
                return "Unknown";
            }
            case O: {
                return "Other";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case E: {
                return "E";
            }
            case C: {
                return "C";
            }
            case U: {
                return "U";
            }
            case O: {
                return "O";
            }
        }
        return "?";
    }
}

