/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum ContractType {
    PRIVACY,
    DISCLOSURE,
    NULL;


    public static ContractType fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("privacy".equals(codeString)) {
            return PRIVACY;
        }
        if ("disclosure".equals(codeString)) {
            return DISCLOSURE;
        }
        throw new Exception("Unknown ContractType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PRIVACY: {
                return "privacy";
            }
            case DISCLOSURE: {
                return "disclosure";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/contracttypecodes";
    }

    public String getDefinition() {
        switch (this) {
            case PRIVACY: {
                return "";
            }
            case DISCLOSURE: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PRIVACY: {
                return "privacy";
            }
            case DISCLOSURE: {
                return "disclosure";
            }
        }
        return "?";
    }
}

