/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum ContractTermType {
    ORALHEALTH,
    VISION,
    NULL;


    public static ContractTermType fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("OralHealth".equals(codeString)) {
            return ORALHEALTH;
        }
        if ("Vision".equals(codeString)) {
            return VISION;
        }
        throw new Exception("Unknown ContractTermType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ORALHEALTH: {
                return "OralHealth";
            }
            case VISION: {
                return "Vision";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/contracttermtypecodes";
    }

    public String getDefinition() {
        switch (this) {
            case ORALHEALTH: {
                return "";
            }
            case VISION: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ORALHEALTH: {
                return "OralHealth";
            }
            case VISION: {
                return "Vision";
            }
        }
        return "?";
    }
}

