/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum ContractTermSubtype {
    ORALHEALTHBASIC,
    ORALHEALTHMAJOR,
    ORALHEALTHORTHODONTIC,
    NULL;


    public static ContractTermSubtype fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("OralHealth-Basic".equals(codeString)) {
            return ORALHEALTHBASIC;
        }
        if ("OralHealth-Major".equals(codeString)) {
            return ORALHEALTHMAJOR;
        }
        if ("OralHealth-Orthodontic".equals(codeString)) {
            return ORALHEALTHORTHODONTIC;
        }
        throw new Exception("Unknown ContractTermSubtype code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ORALHEALTHBASIC: {
                return "OralHealth-Basic";
            }
            case ORALHEALTHMAJOR: {
                return "OralHealth-Major";
            }
            case ORALHEALTHORTHODONTIC: {
                return "OralHealth-Orthodontic";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/contracttermsubtypecodes";
    }

    public String getDefinition() {
        switch (this) {
            case ORALHEALTHBASIC: {
                return "";
            }
            case ORALHEALTHMAJOR: {
                return "";
            }
            case ORALHEALTHORTHODONTIC: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ORALHEALTHBASIC: {
                return "OralHealth-Basic";
            }
            case ORALHEALTHMAJOR: {
                return "OralHealth-Major";
            }
            case ORALHEALTHORTHODONTIC: {
                return "OralHealth-Orthodontic";
            }
        }
        return "?";
    }
}

