/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum ContractActorrole {
    PRACTITIONER,
    PATIENT,
    NULL;


    public static ContractActorrole fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("practitioner".equals(codeString)) {
            return PRACTITIONER;
        }
        if ("patient".equals(codeString)) {
            return PATIENT;
        }
        throw new Exception("Unknown ContractActorrole code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PRACTITIONER: {
                return "practitioner";
            }
            case PATIENT: {
                return "patient";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://www.hl7.org/fhir/contractactorrole";
    }

    public String getDefinition() {
        switch (this) {
            case PRACTITIONER: {
                return "";
            }
            case PATIENT: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PRACTITIONER: {
                return "Practitioner";
            }
            case PATIENT: {
                return "Patient";
            }
        }
        return "?";
    }
}

