/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum ConditionCategory {
    COMPLAINT,
    SYMPTOM,
    FINDING,
    DIAGNOSIS,
    NULL;


    public static ConditionCategory fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("complaint".equals(codeString)) {
            return COMPLAINT;
        }
        if ("symptom".equals(codeString)) {
            return SYMPTOM;
        }
        if ("finding".equals(codeString)) {
            return FINDING;
        }
        if ("diagnosis".equals(codeString)) {
            return DIAGNOSIS;
        }
        throw new Exception("Unknown ConditionCategory code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case COMPLAINT: {
                return "complaint";
            }
            case SYMPTOM: {
                return "symptom";
            }
            case FINDING: {
                return "finding";
            }
            case DIAGNOSIS: {
                return "diagnosis";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/condition-category";
    }

    public String getDefinition() {
        switch (this) {
            case COMPLAINT: {
                return "The patient considers the condition an issue to be addressed.";
            }
            case SYMPTOM: {
                return "A symptom of a condition (as might be mentioned in a review of systems).";
            }
            case FINDING: {
                return "An observation made by a healthcare provider.";
            }
            case DIAGNOSIS: {
                return "This is a judgment made by a healthcare provider that the patient has a particular disease or condition.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case COMPLAINT: {
                return "Complaint";
            }
            case SYMPTOM: {
                return "Symptom";
            }
            case FINDING: {
                return "Finding";
            }
            case DIAGNOSIS: {
                return "Diagnosis";
            }
        }
        return "?";
    }
}

