/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum ClaimException {
    STUDENT,
    DISABLED,
    NULL;


    public static ClaimException fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("student".equals(codeString)) {
            return STUDENT;
        }
        if ("disabled".equals(codeString)) {
            return DISABLED;
        }
        throw new Exception("Unknown ClaimException code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case STUDENT: {
                return "student";
            }
            case DISABLED: {
                return "disabled";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/exception";
    }

    public String getDefinition() {
        switch (this) {
            case STUDENT: {
                return "Fulltime Student";
            }
            case DISABLED: {
                return "Disabled";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case STUDENT: {
                return "Student (Fulltime)";
            }
            case DISABLED: {
                return "Disabled";
            }
        }
        return "?";
    }
}

