/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum CarePlanGoalStatus {
    INPROGRESS,
    ACHIEVED,
    SUSTAINING,
    CANCELLED,
    NULL;


    public static CarePlanGoalStatus fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("in-progress".equals(codeString)) {
            return INPROGRESS;
        }
        if ("achieved".equals(codeString)) {
            return ACHIEVED;
        }
        if ("sustaining".equals(codeString)) {
            return SUSTAINING;
        }
        if ("cancelled".equals(codeString)) {
            return CANCELLED;
        }
        throw new Exception("Unknown CarePlanGoalStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case INPROGRESS: {
                return "in-progress";
            }
            case ACHIEVED: {
                return "achieved";
            }
            case SUSTAINING: {
                return "sustaining";
            }
            case CANCELLED: {
                return "cancelled";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/care-plan-goal-status";
    }

    public String getDefinition() {
        switch (this) {
            case INPROGRESS: {
                return "The goal is being sought but has not yet been reached.  (Also applies if goal was reached in the past but there has been regression and goal is being sought again)";
            }
            case ACHIEVED: {
                return "The goal has been met and no further action is needed";
            }
            case SUSTAINING: {
                return "The goal has been met, but ongoing activity is needed to sustain the goal objective";
            }
            case CANCELLED: {
                return "The goal is no longer being sought";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case INPROGRESS: {
                return "In Progress";
            }
            case ACHIEVED: {
                return "Achieved";
            }
            case SUSTAINING: {
                return "Sustaining";
            }
            case CANCELLED: {
                return "Cancelled";
            }
        }
        return "?";
    }
}

