/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum AnimalSpecies {
    CANISLF,
    OVISA,
    SERINUSCD,
    NULL;


    public static AnimalSpecies fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("canislf".equals(codeString)) {
            return CANISLF;
        }
        if ("ovisa".equals(codeString)) {
            return OVISA;
        }
        if ("serinuscd".equals(codeString)) {
            return SERINUSCD;
        }
        throw new Exception("Unknown AnimalSpecies code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case CANISLF: {
                return "canislf";
            }
            case OVISA: {
                return "ovisa";
            }
            case SERINUSCD: {
                return "serinuscd";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/animal-species";
    }

    public String getDefinition() {
        switch (this) {
            case CANISLF: {
                return "Canis lupus familiaris";
            }
            case OVISA: {
                return "Ovis aries";
            }
            case SERINUSCD: {
                return "Serinus canaria domestica";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case CANISLF: {
                return "Dog";
            }
            case OVISA: {
                return "Sheep";
            }
            case SERINUSCD: {
                return "Domestic Canary";
            }
        }
        return "?";
    }
}

