/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum AnimalBreeds {
    GSD,
    IRT,
    TIBMAS,
    GRET,
    NULL;


    public static AnimalBreeds fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("gsd".equals(codeString)) {
            return GSD;
        }
        if ("irt".equals(codeString)) {
            return IRT;
        }
        if ("tibmas".equals(codeString)) {
            return TIBMAS;
        }
        if ("gret".equals(codeString)) {
            return GRET;
        }
        throw new Exception("Unknown AnimalBreeds code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case GSD: {
                return "gsd";
            }
            case IRT: {
                return "irt";
            }
            case TIBMAS: {
                return "tibmas";
            }
            case GRET: {
                return "gret";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/animal-breed";
    }

    public String getDefinition() {
        switch (this) {
            case GSD: {
                return "";
            }
            case IRT: {
                return "";
            }
            case TIBMAS: {
                return "";
            }
            case GRET: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case GSD: {
                return "German Shepherd Dog";
            }
            case IRT: {
                return "Irish Terrier";
            }
            case TIBMAS: {
                return "Tibetan Mastiff";
            }
            case GRET: {
                return "Golden Retriever";
            }
        }
        return "?";
    }
}

