/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model.valuesets;

public enum Adjudication {
    TOTAL,
    COPAY,
    ELIGIBLE,
    DEDUCTIBLE,
    ELIGPERCENT,
    TAX,
    BENEFIT,
    NULL;


    public static Adjudication fromCode(String codeString) throws Exception {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("total".equals(codeString)) {
            return TOTAL;
        }
        if ("copay".equals(codeString)) {
            return COPAY;
        }
        if ("eligible".equals(codeString)) {
            return ELIGIBLE;
        }
        if ("deductible".equals(codeString)) {
            return DEDUCTIBLE;
        }
        if ("eligpercent".equals(codeString)) {
            return ELIGPERCENT;
        }
        if ("tax".equals(codeString)) {
            return TAX;
        }
        if ("benefit".equals(codeString)) {
            return BENEFIT;
        }
        throw new Exception("Unknown Adjudication code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case TOTAL: {
                return "total";
            }
            case COPAY: {
                return "copay";
            }
            case ELIGIBLE: {
                return "eligible";
            }
            case DEDUCTIBLE: {
                return "deductible";
            }
            case ELIGPERCENT: {
                return "eligpercent";
            }
            case TAX: {
                return "tax";
            }
            case BENEFIT: {
                return "benefit";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/adjudication";
    }

    public String getDefinition() {
        switch (this) {
            case TOTAL: {
                return "";
            }
            case COPAY: {
                return "";
            }
            case ELIGIBLE: {
                return "";
            }
            case DEDUCTIBLE: {
                return "";
            }
            case ELIGPERCENT: {
                return "";
            }
            case TAX: {
                return "";
            }
            case BENEFIT: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case TOTAL: {
                return "total";
            }
            case COPAY: {
                return "copay";
            }
            case ELIGIBLE: {
                return "eligible";
            }
            case DEDUCTIBLE: {
                return "deductible";
            }
            case ELIGPERCENT: {
                return "eligpercent";
            }
            case TAX: {
                return "tax";
            }
            case BENEFIT: {
                return "benefit";
            }
        }
        return "?";
    }
}

