/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.Address;
import org.hl7.fhir.instance.model.Attachment;
import org.hl7.fhir.instance.model.Base;
import org.hl7.fhir.instance.model.CodeType;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Configuration;
import org.hl7.fhir.instance.model.ContactPoint;
import org.hl7.fhir.instance.model.DateType;
import org.hl7.fhir.instance.model.DomainResource;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Enumerations;
import org.hl7.fhir.instance.model.HumanName;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Patient;
import org.hl7.fhir.instance.model.Period;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Reference;
import org.hl7.fhir.instance.model.ResourceType;

@ResourceDef(name="RelatedPerson", profile="http://hl7.org/fhir/Profile/RelatedPerson")
public class RelatedPerson
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A human identifier for this person", formalDefinition="Identifier for a person within a particular scope.")
    protected List<Identifier> identifier;
    @Child(name="patient", type={Patient.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The patient this person is related to", formalDefinition="The patient this person is related to.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="relationship", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The nature of the relationship", formalDefinition="The nature of the relationship between a patient and the related person.")
    protected CodeableConcept relationship;
    @Child(name="name", type={HumanName.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A name associated with the person", formalDefinition="A name associated with the person.")
    protected HumanName name;
    @Child(name="telecom", type={ContactPoint.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A contact detail for the person", formalDefinition="A contact detail for the person, e.g. a telephone number or an email address.")
    protected List<ContactPoint> telecom;
    @Child(name="gender", type={CodeType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="male | female | other | unknown", formalDefinition="Administrative Gender - the gender that the person is considered to have for administration and record keeping purposes.")
    protected Enumeration<Enumerations.AdministrativeGender> gender;
    @Child(name="birthDate", type={DateType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The date on which the related person was born", formalDefinition="The date on which the related person was born.")
    protected DateType birthDate;
    @Child(name="address", type={Address.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Address where the related person can be contacted or visited", formalDefinition="Address where the related person can be contacted or visited.")
    protected List<Address> address;
    @Child(name="photo", type={Attachment.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Image of the person", formalDefinition="Image of the person.")
    protected List<Attachment> photo;
    @Child(name="period", type={Period.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Period of time that this relationship is considered valid", formalDefinition="The period of time that this relationship is considered to be valid. If there are no dates defined, then the interval is unknown.")
    protected Period period;
    private static final long serialVersionUID = 7777543L;
    @SearchParamDefinition(name="identifier", path="RelatedPerson.identifier", description="A patient Identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="address", path="RelatedPerson.address", description="An address in any kind of address/part", type="string")
    public static final String SP_ADDRESS = "address";
    @SearchParamDefinition(name="birthdate", path="RelatedPerson.birthDate", description="The Related Person's date of birth", type="date")
    public static final String SP_BIRTHDATE = "birthdate";
    @SearchParamDefinition(name="address-state", path="RelatedPerson.address.state", description="A state specified in an address", type="string")
    public static final String SP_ADDRESSSTATE = "address-state";
    @SearchParamDefinition(name="gender", path="RelatedPerson.gender", description="Gender of the person", type="token")
    public static final String SP_GENDER = "gender";
    @SearchParamDefinition(name="address-postalcode", path="RelatedPerson.address.postalCode", description="A postal code specified in an address", type="string")
    public static final String SP_ADDRESSPOSTALCODE = "address-postalcode";
    @SearchParamDefinition(name="address-country", path="RelatedPerson.address.country", description="A country specified in an address", type="string")
    public static final String SP_ADDRESSCOUNTRY = "address-country";
    @SearchParamDefinition(name="phonetic", path="RelatedPerson.name", description="A portion of name using some kind of phonetic matching algorithm", type="string")
    public static final String SP_PHONETIC = "phonetic";
    @SearchParamDefinition(name="phone", path="RelatedPerson.telecom.where(system='phone')", description="A value in a phone contact", type="token")
    public static final String SP_PHONE = "phone";
    @SearchParamDefinition(name="patient", path="RelatedPerson.patient", description="The patient this person is related to", type="reference")
    public static final String SP_PATIENT = "patient";
    @SearchParamDefinition(name="name", path="RelatedPerson.name", description="A portion of name in any name part", type="string")
    public static final String SP_NAME = "name";
    @SearchParamDefinition(name="address-use", path="RelatedPerson.address.use", description="A use code specified in an address", type="token")
    public static final String SP_ADDRESSUSE = "address-use";
    @SearchParamDefinition(name="telecom", path="RelatedPerson.telecom", description="The value in any kind of contact", type="token")
    public static final String SP_TELECOM = "telecom";
    @SearchParamDefinition(name="address-city", path="RelatedPerson.address.city", description="A city specified in an address", type="string")
    public static final String SP_ADDRESSCITY = "address-city";
    @SearchParamDefinition(name="email", path="RelatedPerson.telecom.where(system='email')", description="A value in an email contact", type="token")
    public static final String SP_EMAIL = "email";

    public RelatedPerson() {
    }

    public RelatedPerson(Reference patient) {
        this.patient = patient;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public RelatedPerson addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RelatedPerson.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public RelatedPerson setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RelatedPerson.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public RelatedPerson setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public CodeableConcept getRelationship() {
        if (this.relationship == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RelatedPerson.relationship");
            }
            if (Configuration.doAutoCreate()) {
                this.relationship = new CodeableConcept();
            }
        }
        return this.relationship;
    }

    public boolean hasRelationship() {
        return this.relationship != null && !this.relationship.isEmpty();
    }

    public RelatedPerson setRelationship(CodeableConcept value) {
        this.relationship = value;
        return this;
    }

    public HumanName getName() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RelatedPerson.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new HumanName();
            }
        }
        return this.name;
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public RelatedPerson setName(HumanName value) {
        this.name = value;
        return this;
    }

    public List<ContactPoint> getTelecom() {
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        return this.telecom;
    }

    public boolean hasTelecom() {
        if (this.telecom == null) {
            return false;
        }
        for (ContactPoint item : this.telecom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addTelecom() {
        ContactPoint t = new ContactPoint();
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return t;
    }

    public RelatedPerson addTelecom(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return this;
    }

    public Enumeration<Enumerations.AdministrativeGender> getGenderElement() {
        if (this.gender == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RelatedPerson.gender");
            }
            if (Configuration.doAutoCreate()) {
                this.gender = new Enumeration<Enumerations.AdministrativeGender>(new Enumerations.AdministrativeGenderEnumFactory());
            }
        }
        return this.gender;
    }

    public boolean hasGenderElement() {
        return this.gender != null && !this.gender.isEmpty();
    }

    public boolean hasGender() {
        return this.gender != null && !this.gender.isEmpty();
    }

    public RelatedPerson setGenderElement(Enumeration<Enumerations.AdministrativeGender> value) {
        this.gender = value;
        return this;
    }

    public Enumerations.AdministrativeGender getGender() {
        return this.gender == null ? null : (Enumerations.AdministrativeGender)((Object)this.gender.getValue());
    }

    public RelatedPerson setGender(Enumerations.AdministrativeGender value) {
        if (value == null) {
            this.gender = null;
        } else {
            if (this.gender == null) {
                this.gender = new Enumeration<Enumerations.AdministrativeGender>(new Enumerations.AdministrativeGenderEnumFactory());
            }
            this.gender.setValue((Object)value);
        }
        return this;
    }

    public DateType getBirthDateElement() {
        if (this.birthDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RelatedPerson.birthDate");
            }
            if (Configuration.doAutoCreate()) {
                this.birthDate = new DateType();
            }
        }
        return this.birthDate;
    }

    public boolean hasBirthDateElement() {
        return this.birthDate != null && !this.birthDate.isEmpty();
    }

    public boolean hasBirthDate() {
        return this.birthDate != null && !this.birthDate.isEmpty();
    }

    public RelatedPerson setBirthDateElement(DateType value) {
        this.birthDate = value;
        return this;
    }

    public Date getBirthDate() {
        return this.birthDate == null ? null : (Date)this.birthDate.getValue();
    }

    public RelatedPerson setBirthDate(Date value) {
        if (value == null) {
            this.birthDate = null;
        } else {
            if (this.birthDate == null) {
                this.birthDate = new DateType();
            }
            this.birthDate.setValue(value);
        }
        return this;
    }

    public List<Address> getAddress() {
        if (this.address == null) {
            this.address = new ArrayList<Address>();
        }
        return this.address;
    }

    public boolean hasAddress() {
        if (this.address == null) {
            return false;
        }
        for (Address item : this.address) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Address addAddress() {
        Address t = new Address();
        if (this.address == null) {
            this.address = new ArrayList<Address>();
        }
        this.address.add(t);
        return t;
    }

    public RelatedPerson addAddress(Address t) {
        if (t == null) {
            return this;
        }
        if (this.address == null) {
            this.address = new ArrayList<Address>();
        }
        this.address.add(t);
        return this;
    }

    public List<Attachment> getPhoto() {
        if (this.photo == null) {
            this.photo = new ArrayList<Attachment>();
        }
        return this.photo;
    }

    public boolean hasPhoto() {
        if (this.photo == null) {
            return false;
        }
        for (Attachment item : this.photo) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Attachment addPhoto() {
        Attachment t = new Attachment();
        if (this.photo == null) {
            this.photo = new ArrayList<Attachment>();
        }
        this.photo.add(t);
        return t;
    }

    public RelatedPerson addPhoto(Attachment t) {
        if (t == null) {
            return this;
        }
        if (this.photo == null) {
            this.photo = new ArrayList<Attachment>();
        }
        this.photo.add(t);
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RelatedPerson.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public RelatedPerson setPeriod(Period value) {
        this.period = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Identifier for a person within a particular scope.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_PATIENT, "Reference(Patient)", "The patient this person is related to.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property("relationship", "CodeableConcept", "The nature of the relationship between a patient and the related person.", 0, Integer.MAX_VALUE, this.relationship));
        childrenList.add(new Property(SP_NAME, "HumanName", "A name associated with the person.", 0, Integer.MAX_VALUE, this.name));
        childrenList.add(new Property(SP_TELECOM, "ContactPoint", "A contact detail for the person, e.g. a telephone number or an email address.", 0, Integer.MAX_VALUE, this.telecom));
        childrenList.add(new Property(SP_GENDER, "code", "Administrative Gender - the gender that the person is considered to have for administration and record keeping purposes.", 0, Integer.MAX_VALUE, this.gender));
        childrenList.add(new Property("birthDate", "date", "The date on which the related person was born.", 0, Integer.MAX_VALUE, this.birthDate));
        childrenList.add(new Property(SP_ADDRESS, "Address", "Address where the related person can be contacted or visited.", 0, Integer.MAX_VALUE, this.address));
        childrenList.add(new Property("photo", "Attachment", "Image of the person.", 0, Integer.MAX_VALUE, this.photo));
        childrenList.add(new Property("period", "Period", "The period of time that this relationship is considered to be valid. If there are no dates defined, then the interval is unknown.", 0, Integer.MAX_VALUE, this.period));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals("relationship")) {
            this.relationship = this.castToCodeableConcept(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToHumanName(value);
        } else if (name.equals(SP_TELECOM)) {
            this.getTelecom().add(this.castToContactPoint(value));
        } else if (name.equals(SP_GENDER)) {
            this.gender = new Enumerations.AdministrativeGenderEnumFactory().fromType(value);
        } else if (name.equals("birthDate")) {
            this.birthDate = this.castToDate(value);
        } else if (name.equals(SP_ADDRESS)) {
            this.getAddress().add(this.castToAddress(value));
        } else if (name.equals("photo")) {
            this.getPhoto().add(this.castToAttachment(value));
        } else if (name.equals("period")) {
            this.period = this.castToPeriod(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("relationship")) {
            this.relationship = new CodeableConcept();
            return this.relationship;
        }
        if (name.equals(SP_NAME)) {
            this.name = new HumanName();
            return this.name;
        }
        if (name.equals(SP_TELECOM)) {
            return this.addTelecom();
        }
        if (name.equals(SP_GENDER)) {
            throw new FHIRException("Cannot call addChild on a primitive type RelatedPerson.gender");
        }
        if (name.equals("birthDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type RelatedPerson.birthDate");
        }
        if (name.equals(SP_ADDRESS)) {
            return this.addAddress();
        }
        if (name.equals("photo")) {
            return this.addPhoto();
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "RelatedPerson";
    }

    @Override
    public RelatedPerson copy() {
        RelatedPerson dst = new RelatedPerson();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.relationship = this.relationship == null ? null : this.relationship.copy();
        HumanName humanName = dst.name = this.name == null ? null : this.name.copy();
        if (this.telecom != null) {
            dst.telecom = new ArrayList<ContactPoint>();
            for (ContactPoint contactPoint : this.telecom) {
                dst.telecom.add(contactPoint.copy());
            }
        }
        dst.gender = this.gender == null ? null : this.gender.copy();
        DateType dateType = dst.birthDate = this.birthDate == null ? null : this.birthDate.copy();
        if (this.address != null) {
            dst.address = new ArrayList<Address>();
            for (Address address : this.address) {
                dst.address.add(address.copy());
            }
        }
        if (this.photo != null) {
            dst.photo = new ArrayList<Attachment>();
            for (Attachment attachment : this.photo) {
                dst.photo.add(attachment.copy());
            }
        }
        dst.period = this.period == null ? null : this.period.copy();
        return dst;
    }

    protected RelatedPerson typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof RelatedPerson)) {
            return false;
        }
        RelatedPerson o = (RelatedPerson)other;
        return RelatedPerson.compareDeep(this.identifier, o.identifier, true) && RelatedPerson.compareDeep(this.patient, o.patient, true) && RelatedPerson.compareDeep(this.relationship, o.relationship, true) && RelatedPerson.compareDeep(this.name, o.name, true) && RelatedPerson.compareDeep(this.telecom, o.telecom, true) && RelatedPerson.compareDeep(this.gender, o.gender, true) && RelatedPerson.compareDeep(this.birthDate, o.birthDate, true) && RelatedPerson.compareDeep(this.address, o.address, true) && RelatedPerson.compareDeep(this.photo, o.photo, true) && RelatedPerson.compareDeep(this.period, o.period, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof RelatedPerson)) {
            return false;
        }
        RelatedPerson o = (RelatedPerson)other;
        return RelatedPerson.compareValues(this.gender, o.gender, true) && RelatedPerson.compareValues(this.birthDate, o.birthDate, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.patient != null && !this.patient.isEmpty() || this.relationship != null && !this.relationship.isEmpty() || this.name != null && !this.name.isEmpty() || this.telecom != null && !this.telecom.isEmpty() || this.gender != null && !this.gender.isEmpty() || this.birthDate != null && !this.birthDate.isEmpty() || this.address != null && !this.address.isEmpty() || this.photo != null && !this.photo.isEmpty() || this.period != null && !this.period.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.RelatedPerson;
    }
}

