/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.Base;
import org.hl7.fhir.instance.model.BaseReference;
import org.hl7.fhir.instance.model.Configuration;
import org.hl7.fhir.instance.model.IdType;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="Reference")
public class Reference
extends BaseReference
implements IBaseReference,
ICompositeType {
    @Child(name="reference", type={StringType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Relative, internal or absolute URL reference", formalDefinition="A reference to a location at which the other resource is found. The reference may be a relative reference, in which case it is relative to the service base URL, or an absolute URL that resolves to the location where the resource is found. The reference may be version specific or not. If the reference is not to a FHIR RESTful server, then it should be assumed to be version specific. Internal fragment references (start with '#') refer to contained resources.")
    protected StringType reference;
    @Child(name="display", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Text alternative for the resource", formalDefinition="Plain text narrative that identifies the resource in addition to the resource reference.")
    protected StringType display;
    private static final long serialVersionUID = 22777321L;

    public Reference() {
    }

    public Reference(String theReference) {
        super(theReference);
    }

    public Reference(IdType theReference) {
        super(theReference);
    }

    public Reference(IAnyResource theResource) {
        super(theResource);
    }

    public boolean hasReferenceElement() {
        return this.reference != null && !this.reference.isEmpty();
    }

    public boolean hasReference() {
        return this.reference != null && !this.reference.isEmpty();
    }

    public Reference setReferenceElement(StringType value) {
        this.reference = value;
        return this;
    }

    @Override
    public String getReference() {
        return this.reference == null ? null : (String)this.reference.getValue();
    }

    public Reference setReference(String value) {
        if (Utilities.noString((String)value)) {
            this.reference = null;
        } else {
            if (this.reference == null) {
                this.reference = new StringType();
            }
            this.reference.setValue(value);
        }
        return this;
    }

    public StringType getDisplayElement() {
        if (this.display == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Reference.display");
            }
            if (Configuration.doAutoCreate()) {
                this.display = new StringType();
            }
        }
        return this.display;
    }

    public boolean hasDisplayElement() {
        return this.display != null && !this.display.isEmpty();
    }

    public boolean hasDisplay() {
        return this.display != null && !this.display.isEmpty();
    }

    public Reference setDisplayElement(StringType value) {
        this.display = value;
        return this;
    }

    public String getDisplay() {
        return this.display == null ? null : (String)this.display.getValue();
    }

    public Reference setDisplay(String value) {
        if (Utilities.noString((String)value)) {
            this.display = null;
        } else {
            if (this.display == null) {
                this.display = new StringType();
            }
            this.display.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("reference", "string", "A reference to a location at which the other resource is found. The reference may be a relative reference, in which case it is relative to the service base URL, or an absolute URL that resolves to the location where the resource is found. The reference may be version specific or not. If the reference is not to a FHIR RESTful server, then it should be assumed to be version specific. Internal fragment references (start with '#') refer to contained resources.", 0, Integer.MAX_VALUE, this.reference));
        childrenList.add(new Property("display", "string", "Plain text narrative that identifies the resource in addition to the resource reference.", 0, Integer.MAX_VALUE, this.display));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("reference")) {
            this.reference = this.castToString(value);
        } else if (name.equals("display")) {
            this.display = this.castToString(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("reference")) {
            throw new FHIRException("Cannot call addChild on a primitive type Reference.reference");
        }
        if (name.equals("display")) {
            throw new FHIRException("Cannot call addChild on a primitive type Reference.display");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Reference";
    }

    @Override
    public Reference copy() {
        Reference dst = new Reference();
        this.copyValues(dst);
        dst.reference = this.reference == null ? null : this.reference.copy();
        dst.display = this.display == null ? null : this.display.copy();
        return dst;
    }

    @Override
    protected Reference typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Reference)) {
            return false;
        }
        Reference o = (Reference)other;
        return Reference.compareDeep(this.reference, o.reference, true) && Reference.compareDeep(this.display, o.display, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Reference)) {
            return false;
        }
        Reference o = (Reference)other;
        return Reference.compareValues(this.reference, o.reference, true) && Reference.compareValues(this.display, o.display, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.reference != null && !this.reference.isEmpty() || this.display != null && !this.display.isEmpty());
    }
}

