/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.Base;
import org.hl7.fhir.instance.model.Configuration;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Quantity;
import org.hl7.fhir.instance.model.Type;
import org.hl7.fhir.instance.model.api.ICompositeType;

@DatatypeDef(name="Ratio")
public class Ratio
extends Type
implements ICompositeType {
    @Child(name="numerator", type={Quantity.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Numerator value", formalDefinition="The value of the numerator.")
    protected Quantity numerator;
    @Child(name="denominator", type={Quantity.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Denominator value", formalDefinition="The value of the denominator.")
    protected Quantity denominator;
    private static final long serialVersionUID = 479922563L;

    public Quantity getNumerator() {
        if (this.numerator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Ratio.numerator");
            }
            if (Configuration.doAutoCreate()) {
                this.numerator = new Quantity();
            }
        }
        return this.numerator;
    }

    public boolean hasNumerator() {
        return this.numerator != null && !this.numerator.isEmpty();
    }

    public Ratio setNumerator(Quantity value) {
        this.numerator = value;
        return this;
    }

    public Quantity getDenominator() {
        if (this.denominator == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Ratio.denominator");
            }
            if (Configuration.doAutoCreate()) {
                this.denominator = new Quantity();
            }
        }
        return this.denominator;
    }

    public boolean hasDenominator() {
        return this.denominator != null && !this.denominator.isEmpty();
    }

    public Ratio setDenominator(Quantity value) {
        this.denominator = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("numerator", "Quantity", "The value of the numerator.", 0, Integer.MAX_VALUE, this.numerator));
        childrenList.add(new Property("denominator", "Quantity", "The value of the denominator.", 0, Integer.MAX_VALUE, this.denominator));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("numerator")) {
            this.numerator = this.castToQuantity(value);
        } else if (name.equals("denominator")) {
            this.denominator = this.castToQuantity(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("numerator")) {
            this.numerator = new Quantity();
            return this.numerator;
        }
        if (name.equals("denominator")) {
            this.denominator = new Quantity();
            return this.denominator;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Ratio";
    }

    @Override
    public Ratio copy() {
        Ratio dst = new Ratio();
        this.copyValues(dst);
        dst.numerator = this.numerator == null ? null : this.numerator.copy();
        dst.denominator = this.denominator == null ? null : this.denominator.copy();
        return dst;
    }

    @Override
    protected Ratio typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Ratio)) {
            return false;
        }
        Ratio o = (Ratio)other;
        return Ratio.compareDeep(this.numerator, o.numerator, true) && Ratio.compareDeep(this.denominator, o.denominator, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Ratio)) {
            return false;
        }
        Ratio o = (Ratio)other;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.numerator != null && !this.numerator.isEmpty() || this.denominator != null && !this.denominator.isEmpty());
    }
}

