/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.Address;
import org.hl7.fhir.instance.model.Annotation;
import org.hl7.fhir.instance.model.Attachment;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.Base;
import org.hl7.fhir.instance.model.Base64BinaryType;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CodeType;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Coding;
import org.hl7.fhir.instance.model.Configuration;
import org.hl7.fhir.instance.model.ContactPoint;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.DateType;
import org.hl7.fhir.instance.model.DecimalType;
import org.hl7.fhir.instance.model.HumanName;
import org.hl7.fhir.instance.model.IdType;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.InstantType;
import org.hl7.fhir.instance.model.IntegerType;
import org.hl7.fhir.instance.model.MarkdownType;
import org.hl7.fhir.instance.model.Meta;
import org.hl7.fhir.instance.model.OidType;
import org.hl7.fhir.instance.model.Period;
import org.hl7.fhir.instance.model.PositiveIntType;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Quantity;
import org.hl7.fhir.instance.model.Range;
import org.hl7.fhir.instance.model.Ratio;
import org.hl7.fhir.instance.model.Reference;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.SampledData;
import org.hl7.fhir.instance.model.Signature;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.TimeType;
import org.hl7.fhir.instance.model.Timing;
import org.hl7.fhir.instance.model.Type;
import org.hl7.fhir.instance.model.UnsignedIntType;
import org.hl7.fhir.instance.model.UriType;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseParameters;

@ResourceDef(name="Parameters", profile="http://hl7.org/fhir/Profile/Parameters")
public class Parameters
extends Resource
implements IBaseParameters {
    @Child(name="parameter", type={}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Operation Parameter", formalDefinition="A parameter passed to or received from the operation.")
    protected List<ParametersParameterComponent> parameter;
    private static final long serialVersionUID = -1495940293L;

    public List<ParametersParameterComponent> getParameter() {
        if (this.parameter == null) {
            this.parameter = new ArrayList<ParametersParameterComponent>();
        }
        return this.parameter;
    }

    public boolean hasParameter() {
        if (this.parameter == null) {
            return false;
        }
        for (ParametersParameterComponent item : this.parameter) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ParametersParameterComponent addParameter() {
        ParametersParameterComponent t = new ParametersParameterComponent();
        if (this.parameter == null) {
            this.parameter = new ArrayList<ParametersParameterComponent>();
        }
        this.parameter.add(t);
        return t;
    }

    public Parameters addParameter(ParametersParameterComponent t) {
        if (t == null) {
            return this;
        }
        if (this.parameter == null) {
            this.parameter = new ArrayList<ParametersParameterComponent>();
        }
        this.parameter.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("parameter", "", "A parameter passed to or received from the operation.", 0, Integer.MAX_VALUE, this.parameter));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("parameter")) {
            this.getParameter().add((ParametersParameterComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("parameter")) {
            return this.addParameter();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Parameters";
    }

    @Override
    public Parameters copy() {
        Parameters dst = new Parameters();
        this.copyValues(dst);
        if (this.parameter != null) {
            dst.parameter = new ArrayList<ParametersParameterComponent>();
            for (ParametersParameterComponent i : this.parameter) {
                dst.parameter.add(i.copy());
            }
        }
        return dst;
    }

    protected Parameters typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Parameters)) {
            return false;
        }
        Parameters o = (Parameters)other;
        return Parameters.compareDeep(this.parameter, o.parameter, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Parameters)) {
            return false;
        }
        Parameters o = (Parameters)other;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && (this.parameter == null || this.parameter.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Parameters;
    }

    @Block
    public static class ParametersParameterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name from the definition", formalDefinition="The name of the parameter (reference to the operation definition).")
        protected StringType name;
        @Child(name="value", type={}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="If parameter is a data type", formalDefinition="If the parameter is a data type.")
        protected Type value;
        @Child(name="resource", type={Resource.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="If parameter is a whole resource", formalDefinition="If the parameter is a whole resource.")
        protected Resource resource;
        @Child(name="part", type={ParametersParameterComponent.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Named part of a parameter (e.g. Tuple)", formalDefinition="A named part of a parameter. In many implementation context, a set of named parts is known as a \"Tuple\".")
        protected List<ParametersParameterComponent> part;
        private static final long serialVersionUID = -198518915L;

        public ParametersParameterComponent() {
        }

        public ParametersParameterComponent(StringType name) {
            this.name = name;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ParametersParameterComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ParametersParameterComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ParametersParameterComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public Type getValue() {
            return this.value;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ParametersParameterComponent setValue(Type value) {
            this.value = value;
            return this;
        }

        public Resource getResource() {
            return this.resource;
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public ParametersParameterComponent setResource(Resource value) {
            this.resource = value;
            return this;
        }

        public List<ParametersParameterComponent> getPart() {
            if (this.part == null) {
                this.part = new ArrayList<ParametersParameterComponent>();
            }
            return this.part;
        }

        public boolean hasPart() {
            if (this.part == null) {
                return false;
            }
            for (ParametersParameterComponent item : this.part) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ParametersParameterComponent addPart() {
            ParametersParameterComponent t = new ParametersParameterComponent();
            if (this.part == null) {
                this.part = new ArrayList<ParametersParameterComponent>();
            }
            this.part.add(t);
            return t;
        }

        public ParametersParameterComponent addPart(ParametersParameterComponent t) {
            if (t == null) {
                return this;
            }
            if (this.part == null) {
                this.part = new ArrayList<ParametersParameterComponent>();
            }
            this.part.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("name", "string", "The name of the parameter (reference to the operation definition).", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("value[x]", "*", "If the parameter is a data type.", 0, Integer.MAX_VALUE, this.value));
            childrenList.add(new Property("resource", "Resource", "If the parameter is a whole resource.", 0, Integer.MAX_VALUE, this.resource));
            childrenList.add(new Property("part", "@Parameters.parameter", "A named part of a parameter. In many implementation context, a set of named parts is known as a \"Tuple\".", 0, Integer.MAX_VALUE, this.part));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals("value[x]")) {
                this.value = (Type)value;
            } else if (name.equals("resource")) {
                this.resource = this.castToResource(value);
            } else if (name.equals("part")) {
                this.getPart().add((ParametersParameterComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type Parameters.name");
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueDecimal")) {
                this.value = new DecimalType();
                return this.value;
            }
            if (name.equals("valueBase64Binary")) {
                this.value = new Base64BinaryType();
                return this.value;
            }
            if (name.equals("valueInstant")) {
                this.value = new InstantType();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueUri")) {
                this.value = new UriType();
                return this.value;
            }
            if (name.equals("valueDate")) {
                this.value = new DateType();
                return this.value;
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valueTime")) {
                this.value = new TimeType();
                return this.value;
            }
            if (name.equals("valueCode")) {
                this.value = new CodeType();
                return this.value;
            }
            if (name.equals("valueOid")) {
                this.value = new OidType();
                return this.value;
            }
            if (name.equals("valueId")) {
                this.value = new IdType();
                return this.value;
            }
            if (name.equals("valueUnsignedInt")) {
                this.value = new UnsignedIntType();
                return this.value;
            }
            if (name.equals("valuePositiveInt")) {
                this.value = new PositiveIntType();
                return this.value;
            }
            if (name.equals("valueMarkdown")) {
                this.value = new MarkdownType();
                return this.value;
            }
            if (name.equals("valueAnnotation")) {
                this.value = new Annotation();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            if (name.equals("valueIdentifier")) {
                this.value = new Identifier();
                return this.value;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueCoding")) {
                this.value = new Coding();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueRange")) {
                this.value = new Range();
                return this.value;
            }
            if (name.equals("valuePeriod")) {
                this.value = new Period();
                return this.value;
            }
            if (name.equals("valueRatio")) {
                this.value = new Ratio();
                return this.value;
            }
            if (name.equals("valueSampledData")) {
                this.value = new SampledData();
                return this.value;
            }
            if (name.equals("valueSignature")) {
                this.value = new Signature();
                return this.value;
            }
            if (name.equals("valueHumanName")) {
                this.value = new HumanName();
                return this.value;
            }
            if (name.equals("valueAddress")) {
                this.value = new Address();
                return this.value;
            }
            if (name.equals("valueContactPoint")) {
                this.value = new ContactPoint();
                return this.value;
            }
            if (name.equals("valueTiming")) {
                this.value = new Timing();
                return this.value;
            }
            if (name.equals("valueReference")) {
                this.value = new Reference();
                return this.value;
            }
            if (name.equals("valueMeta")) {
                this.value = new Meta();
                return this.value;
            }
            if (name.equals("resource")) {
                throw new FHIRException("Cannot call addChild on an abstract type Parameters.resource");
            }
            if (name.equals("part")) {
                return this.addPart();
            }
            return super.addChild(name);
        }

        @Override
        public ParametersParameterComponent copy() {
            ParametersParameterComponent dst = new ParametersParameterComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.value = this.value == null ? null : this.value.copy();
            Resource resource = dst.resource = this.resource == null ? null : this.resource.copy();
            if (this.part != null) {
                dst.part = new ArrayList<ParametersParameterComponent>();
                for (ParametersParameterComponent i : this.part) {
                    dst.part.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ParametersParameterComponent)) {
                return false;
            }
            ParametersParameterComponent o = (ParametersParameterComponent)other;
            return ParametersParameterComponent.compareDeep(this.name, o.name, true) && ParametersParameterComponent.compareDeep(this.value, o.value, true) && ParametersParameterComponent.compareDeep(this.resource, o.resource, true) && ParametersParameterComponent.compareDeep(this.part, o.part, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ParametersParameterComponent)) {
                return false;
            }
            ParametersParameterComponent o = (ParametersParameterComponent)other;
            return ParametersParameterComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.value != null && !this.value.isEmpty() || this.resource != null && !this.resource.isEmpty() || this.part != null && !this.part.isEmpty());
        }

        @Override
        public String fhirType() {
            return "null";
        }
    }
}

