/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.Base;
import org.hl7.fhir.instance.model.BodySite;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CodeType;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Condition;
import org.hl7.fhir.instance.model.Configuration;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.DomainResource;
import org.hl7.fhir.instance.model.Duration;
import org.hl7.fhir.instance.model.Encounter;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Medication;
import org.hl7.fhir.instance.model.Patient;
import org.hl7.fhir.instance.model.Period;
import org.hl7.fhir.instance.model.PositiveIntType;
import org.hl7.fhir.instance.model.Practitioner;
import org.hl7.fhir.instance.model.PrimitiveType;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Range;
import org.hl7.fhir.instance.model.Ratio;
import org.hl7.fhir.instance.model.Reference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.SimpleQuantity;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.Timing;
import org.hl7.fhir.instance.model.Type;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="MedicationOrder", profile="http://hl7.org/fhir/Profile/MedicationOrder")
public class MedicationOrder
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External identifier", formalDefinition="External identifier - one that would be used by another non-FHIR system - for example a re-imbursement system might issue its own id for each prescription that is created.  This is particularly important where FHIR only provides part of an entire workflow process where records have to be tracked through an entire system.")
    protected List<Identifier> identifier;
    @Child(name="dateWritten", type={DateTimeType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When prescription was authorized", formalDefinition="The date (and perhaps time) when the prescription was written.")
    protected DateTimeType dateWritten;
    @Child(name="status", type={CodeType.class}, order=2, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | on-hold | completed | entered-in-error | stopped | draft", formalDefinition="A code specifying the state of the order.  Generally this will be active or completed state.")
    protected Enumeration<MedicationOrderStatus> status;
    @Child(name="dateEnded", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When prescription was stopped", formalDefinition="The date (and perhaps time) when the prescription was stopped.")
    protected DateTimeType dateEnded;
    @Child(name="reasonEnded", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Why prescription was stopped", formalDefinition="The reason why the prescription was stopped, if it was.")
    protected CodeableConcept reasonEnded;
    @Child(name="patient", type={Patient.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who prescription is for", formalDefinition="A link to a resource representing the person to whom the medication will be given.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="prescriber", type={Practitioner.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who ordered the medication(s)", formalDefinition="The healthcare professional responsible for authorizing the prescription.")
    protected Reference prescriber;
    protected Practitioner prescriberTarget;
    @Child(name="encounter", type={Encounter.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Created during encounter/admission/stay", formalDefinition="A link to a resource that identifies the particular occurrence of contact between patient and health care provider.")
    protected Reference encounter;
    protected Encounter encounterTarget;
    @Child(name="reason", type={CodeableConcept.class, Condition.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reason or indication for writing the prescription", formalDefinition="Can be the reason or the indication for writing the prescription.")
    protected Type reason;
    @Child(name="note", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Information about the prescription", formalDefinition="Extra information about the prescription that could not be conveyed by the other attributes.")
    protected StringType note;
    @Child(name="medication", type={CodeableConcept.class, Medication.class}, order=10, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Medication to be taken", formalDefinition="Identifies the medication being administered. This is a link to a resource that represents the medication which may be the details of the medication or simply an attribute carrying a code that identifies the medication from a known list of medications.")
    protected Type medication;
    @Child(name="dosageInstruction", type={}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="How medication should be taken", formalDefinition="Indicates how the medication is to be used by the patient.")
    protected List<MedicationOrderDosageInstructionComponent> dosageInstruction;
    @Child(name="dispenseRequest", type={}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Medication supply authorization", formalDefinition="Indicates the specific details for the dispense or medication supply part of a medication order (also known as a Medication Prescription).  Note that this information is NOT always sent with the order.  There may be in some settings (e.g. hospitals) institutional or system support for completing the dispense details in the pharmacy department.")
    protected MedicationOrderDispenseRequestComponent dispenseRequest;
    @Child(name="substitution", type={}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Any restrictions on medication substitution", formalDefinition="Indicates whether or not substitution can or should be part of the dispense. In some cases substitution must happen, in other cases substitution must not happen, and in others it does not matter. This block explains the prescriber's intent. If nothing is specified substitution may be done.")
    protected MedicationOrderSubstitutionComponent substitution;
    @Child(name="priorPrescription", type={MedicationOrder.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="An order/prescription that this supersedes", formalDefinition="A link to a resource representing an earlier order or prescription that this order supersedes.")
    protected Reference priorPrescription;
    protected MedicationOrder priorPrescriptionTarget;
    private static final long serialVersionUID = 619326051L;
    @SearchParamDefinition(name="prescriber", path="MedicationOrder.prescriber", description="Who ordered the medication(s)", type="reference")
    public static final String SP_PRESCRIBER = "prescriber";
    @SearchParamDefinition(name="identifier", path="MedicationOrder.identifier", description="Return prescriptions with this external identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="code", path="MedicationOrder.medicationCodeableConcept", description="Return administrations of this medication code", type="token")
    public static final String SP_CODE = "code";
    @SearchParamDefinition(name="patient", path="MedicationOrder.patient", description="The identity of a patient to list orders  for", type="reference")
    public static final String SP_PATIENT = "patient";
    @SearchParamDefinition(name="datewritten", path="MedicationOrder.dateWritten", description="Return prescriptions written on this date", type="date")
    public static final String SP_DATEWRITTEN = "datewritten";
    @SearchParamDefinition(name="medication", path="MedicationOrder.medicationReference", description="Return administrations of this medication reference", type="reference")
    public static final String SP_MEDICATION = "medication";
    @SearchParamDefinition(name="encounter", path="MedicationOrder.encounter", description="Return prescriptions with this encounter identifier", type="reference")
    public static final String SP_ENCOUNTER = "encounter";
    @SearchParamDefinition(name="status", path="MedicationOrder.status", description="Status of the prescription", type="token")
    public static final String SP_STATUS = "status";

    public MedicationOrder() {
    }

    public MedicationOrder(Type medication) {
        this.medication = medication;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public MedicationOrder addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public DateTimeType getDateWrittenElement() {
        if (this.dateWritten == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationOrder.dateWritten");
            }
            if (Configuration.doAutoCreate()) {
                this.dateWritten = new DateTimeType();
            }
        }
        return this.dateWritten;
    }

    public boolean hasDateWrittenElement() {
        return this.dateWritten != null && !this.dateWritten.isEmpty();
    }

    public boolean hasDateWritten() {
        return this.dateWritten != null && !this.dateWritten.isEmpty();
    }

    public MedicationOrder setDateWrittenElement(DateTimeType value) {
        this.dateWritten = value;
        return this;
    }

    public Date getDateWritten() {
        return this.dateWritten == null ? null : (Date)this.dateWritten.getValue();
    }

    public MedicationOrder setDateWritten(Date value) {
        if (value == null) {
            this.dateWritten = null;
        } else {
            if (this.dateWritten == null) {
                this.dateWritten = new DateTimeType();
            }
            this.dateWritten.setValue(value);
        }
        return this;
    }

    public Enumeration<MedicationOrderStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationOrder.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<MedicationOrderStatus>(new MedicationOrderStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public MedicationOrder setStatusElement(Enumeration<MedicationOrderStatus> value) {
        this.status = value;
        return this;
    }

    public MedicationOrderStatus getStatus() {
        return this.status == null ? null : (MedicationOrderStatus)((Object)this.status.getValue());
    }

    public MedicationOrder setStatus(MedicationOrderStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<MedicationOrderStatus>(new MedicationOrderStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public DateTimeType getDateEndedElement() {
        if (this.dateEnded == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationOrder.dateEnded");
            }
            if (Configuration.doAutoCreate()) {
                this.dateEnded = new DateTimeType();
            }
        }
        return this.dateEnded;
    }

    public boolean hasDateEndedElement() {
        return this.dateEnded != null && !this.dateEnded.isEmpty();
    }

    public boolean hasDateEnded() {
        return this.dateEnded != null && !this.dateEnded.isEmpty();
    }

    public MedicationOrder setDateEndedElement(DateTimeType value) {
        this.dateEnded = value;
        return this;
    }

    public Date getDateEnded() {
        return this.dateEnded == null ? null : (Date)this.dateEnded.getValue();
    }

    public MedicationOrder setDateEnded(Date value) {
        if (value == null) {
            this.dateEnded = null;
        } else {
            if (this.dateEnded == null) {
                this.dateEnded = new DateTimeType();
            }
            this.dateEnded.setValue(value);
        }
        return this;
    }

    public CodeableConcept getReasonEnded() {
        if (this.reasonEnded == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationOrder.reasonEnded");
            }
            if (Configuration.doAutoCreate()) {
                this.reasonEnded = new CodeableConcept();
            }
        }
        return this.reasonEnded;
    }

    public boolean hasReasonEnded() {
        return this.reasonEnded != null && !this.reasonEnded.isEmpty();
    }

    public MedicationOrder setReasonEnded(CodeableConcept value) {
        this.reasonEnded = value;
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationOrder.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public MedicationOrder setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationOrder.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public MedicationOrder setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public Reference getPrescriber() {
        if (this.prescriber == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationOrder.prescriber");
            }
            if (Configuration.doAutoCreate()) {
                this.prescriber = new Reference();
            }
        }
        return this.prescriber;
    }

    public boolean hasPrescriber() {
        return this.prescriber != null && !this.prescriber.isEmpty();
    }

    public MedicationOrder setPrescriber(Reference value) {
        this.prescriber = value;
        return this;
    }

    public Practitioner getPrescriberTarget() {
        if (this.prescriberTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationOrder.prescriber");
            }
            if (Configuration.doAutoCreate()) {
                this.prescriberTarget = new Practitioner();
            }
        }
        return this.prescriberTarget;
    }

    public MedicationOrder setPrescriberTarget(Practitioner value) {
        this.prescriberTarget = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationOrder.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public MedicationOrder setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public Encounter getEncounterTarget() {
        if (this.encounterTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationOrder.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounterTarget = new Encounter();
            }
        }
        return this.encounterTarget;
    }

    public MedicationOrder setEncounterTarget(Encounter value) {
        this.encounterTarget = value;
        return this;
    }

    public Type getReason() {
        return this.reason;
    }

    public CodeableConcept getReasonCodeableConcept() throws FHIRException {
        if (!(this.reason instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.reason.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.reason;
    }

    public boolean hasReasonCodeableConcept() {
        return this.reason instanceof CodeableConcept;
    }

    public Reference getReasonReference() throws FHIRException {
        if (!(this.reason instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.reason.getClass().getName() + " was encountered");
        }
        return (Reference)this.reason;
    }

    public boolean hasReasonReference() {
        return this.reason instanceof Reference;
    }

    public boolean hasReason() {
        return this.reason != null && !this.reason.isEmpty();
    }

    public MedicationOrder setReason(Type value) {
        this.reason = value;
        return this;
    }

    public StringType getNoteElement() {
        if (this.note == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationOrder.note");
            }
            if (Configuration.doAutoCreate()) {
                this.note = new StringType();
            }
        }
        return this.note;
    }

    public boolean hasNoteElement() {
        return this.note != null && !this.note.isEmpty();
    }

    public boolean hasNote() {
        return this.note != null && !this.note.isEmpty();
    }

    public MedicationOrder setNoteElement(StringType value) {
        this.note = value;
        return this;
    }

    public String getNote() {
        return this.note == null ? null : (String)this.note.getValue();
    }

    public MedicationOrder setNote(String value) {
        if (Utilities.noString((String)value)) {
            this.note = null;
        } else {
            if (this.note == null) {
                this.note = new StringType();
            }
            this.note.setValue(value);
        }
        return this;
    }

    public Type getMedication() {
        return this.medication;
    }

    public CodeableConcept getMedicationCodeableConcept() throws FHIRException {
        if (!(this.medication instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.medication.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.medication;
    }

    public boolean hasMedicationCodeableConcept() {
        return this.medication instanceof CodeableConcept;
    }

    public Reference getMedicationReference() throws FHIRException {
        if (!(this.medication instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.medication.getClass().getName() + " was encountered");
        }
        return (Reference)this.medication;
    }

    public boolean hasMedicationReference() {
        return this.medication instanceof Reference;
    }

    public boolean hasMedication() {
        return this.medication != null && !this.medication.isEmpty();
    }

    public MedicationOrder setMedication(Type value) {
        this.medication = value;
        return this;
    }

    public List<MedicationOrderDosageInstructionComponent> getDosageInstruction() {
        if (this.dosageInstruction == null) {
            this.dosageInstruction = new ArrayList<MedicationOrderDosageInstructionComponent>();
        }
        return this.dosageInstruction;
    }

    public boolean hasDosageInstruction() {
        if (this.dosageInstruction == null) {
            return false;
        }
        for (MedicationOrderDosageInstructionComponent item : this.dosageInstruction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicationOrderDosageInstructionComponent addDosageInstruction() {
        MedicationOrderDosageInstructionComponent t = new MedicationOrderDosageInstructionComponent();
        if (this.dosageInstruction == null) {
            this.dosageInstruction = new ArrayList<MedicationOrderDosageInstructionComponent>();
        }
        this.dosageInstruction.add(t);
        return t;
    }

    public MedicationOrder addDosageInstruction(MedicationOrderDosageInstructionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.dosageInstruction == null) {
            this.dosageInstruction = new ArrayList<MedicationOrderDosageInstructionComponent>();
        }
        this.dosageInstruction.add(t);
        return this;
    }

    public MedicationOrderDispenseRequestComponent getDispenseRequest() {
        if (this.dispenseRequest == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationOrder.dispenseRequest");
            }
            if (Configuration.doAutoCreate()) {
                this.dispenseRequest = new MedicationOrderDispenseRequestComponent();
            }
        }
        return this.dispenseRequest;
    }

    public boolean hasDispenseRequest() {
        return this.dispenseRequest != null && !this.dispenseRequest.isEmpty();
    }

    public MedicationOrder setDispenseRequest(MedicationOrderDispenseRequestComponent value) {
        this.dispenseRequest = value;
        return this;
    }

    public MedicationOrderSubstitutionComponent getSubstitution() {
        if (this.substitution == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationOrder.substitution");
            }
            if (Configuration.doAutoCreate()) {
                this.substitution = new MedicationOrderSubstitutionComponent();
            }
        }
        return this.substitution;
    }

    public boolean hasSubstitution() {
        return this.substitution != null && !this.substitution.isEmpty();
    }

    public MedicationOrder setSubstitution(MedicationOrderSubstitutionComponent value) {
        this.substitution = value;
        return this;
    }

    public Reference getPriorPrescription() {
        if (this.priorPrescription == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationOrder.priorPrescription");
            }
            if (Configuration.doAutoCreate()) {
                this.priorPrescription = new Reference();
            }
        }
        return this.priorPrescription;
    }

    public boolean hasPriorPrescription() {
        return this.priorPrescription != null && !this.priorPrescription.isEmpty();
    }

    public MedicationOrder setPriorPrescription(Reference value) {
        this.priorPrescription = value;
        return this;
    }

    public MedicationOrder getPriorPrescriptionTarget() {
        if (this.priorPrescriptionTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicationOrder.priorPrescription");
            }
            if (Configuration.doAutoCreate()) {
                this.priorPrescriptionTarget = new MedicationOrder();
            }
        }
        return this.priorPrescriptionTarget;
    }

    public MedicationOrder setPriorPrescriptionTarget(MedicationOrder value) {
        this.priorPrescriptionTarget = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "External identifier - one that would be used by another non-FHIR system - for example a re-imbursement system might issue its own id for each prescription that is created.  This is particularly important where FHIR only provides part of an entire workflow process where records have to be tracked through an entire system.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("dateWritten", "dateTime", "The date (and perhaps time) when the prescription was written.", 0, Integer.MAX_VALUE, this.dateWritten));
        childrenList.add(new Property(SP_STATUS, SP_CODE, "A code specifying the state of the order.  Generally this will be active or completed state.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property("dateEnded", "dateTime", "The date (and perhaps time) when the prescription was stopped.", 0, Integer.MAX_VALUE, this.dateEnded));
        childrenList.add(new Property("reasonEnded", "CodeableConcept", "The reason why the prescription was stopped, if it was.", 0, Integer.MAX_VALUE, this.reasonEnded));
        childrenList.add(new Property(SP_PATIENT, "Reference(Patient)", "A link to a resource representing the person to whom the medication will be given.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property(SP_PRESCRIBER, "Reference(Practitioner)", "The healthcare professional responsible for authorizing the prescription.", 0, Integer.MAX_VALUE, this.prescriber));
        childrenList.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "A link to a resource that identifies the particular occurrence of contact between patient and health care provider.", 0, Integer.MAX_VALUE, this.encounter));
        childrenList.add(new Property("reason[x]", "CodeableConcept|Reference(Condition)", "Can be the reason or the indication for writing the prescription.", 0, Integer.MAX_VALUE, this.reason));
        childrenList.add(new Property("note", "string", "Extra information about the prescription that could not be conveyed by the other attributes.", 0, Integer.MAX_VALUE, this.note));
        childrenList.add(new Property("medication[x]", "CodeableConcept|Reference(Medication)", "Identifies the medication being administered. This is a link to a resource that represents the medication which may be the details of the medication or simply an attribute carrying a code that identifies the medication from a known list of medications.", 0, Integer.MAX_VALUE, this.medication));
        childrenList.add(new Property("dosageInstruction", "", "Indicates how the medication is to be used by the patient.", 0, Integer.MAX_VALUE, this.dosageInstruction));
        childrenList.add(new Property("dispenseRequest", "", "Indicates the specific details for the dispense or medication supply part of a medication order (also known as a Medication Prescription).  Note that this information is NOT always sent with the order.  There may be in some settings (e.g. hospitals) institutional or system support for completing the dispense details in the pharmacy department.", 0, Integer.MAX_VALUE, this.dispenseRequest));
        childrenList.add(new Property("substitution", "", "Indicates whether or not substitution can or should be part of the dispense. In some cases substitution must happen, in other cases substitution must not happen, and in others it does not matter. This block explains the prescriber's intent. If nothing is specified substitution may be done.", 0, Integer.MAX_VALUE, this.substitution));
        childrenList.add(new Property("priorPrescription", "Reference(MedicationOrder)", "A link to a resource representing an earlier order or prescription that this order supersedes.", 0, Integer.MAX_VALUE, this.priorPrescription));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("dateWritten")) {
            this.dateWritten = this.castToDateTime(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = new MedicationOrderStatusEnumFactory().fromType(value);
        } else if (name.equals("dateEnded")) {
            this.dateEnded = this.castToDateTime(value);
        } else if (name.equals("reasonEnded")) {
            this.reasonEnded = this.castToCodeableConcept(value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals(SP_PRESCRIBER)) {
            this.prescriber = this.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = this.castToReference(value);
        } else if (name.equals("reason[x]")) {
            this.reason = (Type)value;
        } else if (name.equals("note")) {
            this.note = this.castToString(value);
        } else if (name.equals("medication[x]")) {
            this.medication = (Type)value;
        } else if (name.equals("dosageInstruction")) {
            this.getDosageInstruction().add((MedicationOrderDosageInstructionComponent)value);
        } else if (name.equals("dispenseRequest")) {
            this.dispenseRequest = (MedicationOrderDispenseRequestComponent)value;
        } else if (name.equals("substitution")) {
            this.substitution = (MedicationOrderSubstitutionComponent)value;
        } else if (name.equals("priorPrescription")) {
            this.priorPrescription = this.castToReference(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("dateWritten")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationOrder.dateWritten");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationOrder.status");
        }
        if (name.equals("dateEnded")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationOrder.dateEnded");
        }
        if (name.equals("reasonEnded")) {
            this.reasonEnded = new CodeableConcept();
            return this.reasonEnded;
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals(SP_PRESCRIBER)) {
            this.prescriber = new Reference();
            return this.prescriber;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("reasonCodeableConcept")) {
            this.reason = new CodeableConcept();
            return this.reason;
        }
        if (name.equals("reasonReference")) {
            this.reason = new Reference();
            return this.reason;
        }
        if (name.equals("note")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicationOrder.note");
        }
        if (name.equals("medicationCodeableConcept")) {
            this.medication = new CodeableConcept();
            return this.medication;
        }
        if (name.equals("medicationReference")) {
            this.medication = new Reference();
            return this.medication;
        }
        if (name.equals("dosageInstruction")) {
            return this.addDosageInstruction();
        }
        if (name.equals("dispenseRequest")) {
            this.dispenseRequest = new MedicationOrderDispenseRequestComponent();
            return this.dispenseRequest;
        }
        if (name.equals("substitution")) {
            this.substitution = new MedicationOrderSubstitutionComponent();
            return this.substitution;
        }
        if (name.equals("priorPrescription")) {
            this.priorPrescription = new Reference();
            return this.priorPrescription;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MedicationOrder";
    }

    @Override
    public MedicationOrder copy() {
        MedicationOrder dst = new MedicationOrder();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.dateWritten = this.dateWritten == null ? null : this.dateWritten.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.dateEnded = this.dateEnded == null ? null : this.dateEnded.copy();
        dst.reasonEnded = this.reasonEnded == null ? null : this.reasonEnded.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.prescriber = this.prescriber == null ? null : this.prescriber.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.reason = this.reason == null ? null : this.reason.copy();
        dst.note = this.note == null ? null : this.note.copy();
        Type type = dst.medication = this.medication == null ? null : this.medication.copy();
        if (this.dosageInstruction != null) {
            dst.dosageInstruction = new ArrayList<MedicationOrderDosageInstructionComponent>();
            for (MedicationOrderDosageInstructionComponent medicationOrderDosageInstructionComponent : this.dosageInstruction) {
                dst.dosageInstruction.add(medicationOrderDosageInstructionComponent.copy());
            }
        }
        dst.dispenseRequest = this.dispenseRequest == null ? null : this.dispenseRequest.copy();
        dst.substitution = this.substitution == null ? null : this.substitution.copy();
        dst.priorPrescription = this.priorPrescription == null ? null : this.priorPrescription.copy();
        return dst;
    }

    protected MedicationOrder typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof MedicationOrder)) {
            return false;
        }
        MedicationOrder o = (MedicationOrder)other;
        return MedicationOrder.compareDeep(this.identifier, o.identifier, true) && MedicationOrder.compareDeep(this.dateWritten, o.dateWritten, true) && MedicationOrder.compareDeep(this.status, o.status, true) && MedicationOrder.compareDeep(this.dateEnded, o.dateEnded, true) && MedicationOrder.compareDeep(this.reasonEnded, o.reasonEnded, true) && MedicationOrder.compareDeep(this.patient, o.patient, true) && MedicationOrder.compareDeep(this.prescriber, o.prescriber, true) && MedicationOrder.compareDeep(this.encounter, o.encounter, true) && MedicationOrder.compareDeep(this.reason, o.reason, true) && MedicationOrder.compareDeep(this.note, o.note, true) && MedicationOrder.compareDeep(this.medication, o.medication, true) && MedicationOrder.compareDeep(this.dosageInstruction, o.dosageInstruction, true) && MedicationOrder.compareDeep(this.dispenseRequest, o.dispenseRequest, true) && MedicationOrder.compareDeep(this.substitution, o.substitution, true) && MedicationOrder.compareDeep(this.priorPrescription, o.priorPrescription, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof MedicationOrder)) {
            return false;
        }
        MedicationOrder o = (MedicationOrder)other;
        return MedicationOrder.compareValues(this.dateWritten, o.dateWritten, true) && MedicationOrder.compareValues(this.status, o.status, true) && MedicationOrder.compareValues(this.dateEnded, o.dateEnded, true) && MedicationOrder.compareValues(this.note, o.note, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.dateWritten != null && !this.dateWritten.isEmpty() || this.status != null && !this.status.isEmpty() || this.dateEnded != null && !this.dateEnded.isEmpty() || this.reasonEnded != null && !this.reasonEnded.isEmpty() || this.patient != null && !this.patient.isEmpty() || this.prescriber != null && !this.prescriber.isEmpty() || this.encounter != null && !this.encounter.isEmpty() || this.reason != null && !this.reason.isEmpty() || this.note != null && !this.note.isEmpty() || this.medication != null && !this.medication.isEmpty() || this.dosageInstruction != null && !this.dosageInstruction.isEmpty() || this.dispenseRequest != null && !this.dispenseRequest.isEmpty() || this.substitution != null && !this.substitution.isEmpty() || this.priorPrescription != null && !this.priorPrescription.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicationOrder;
    }

    @Block
    public static class MedicationOrderSubstitutionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="generic | formulary +", formalDefinition="A code signifying whether a different drug should be dispensed from what was prescribed.")
        protected CodeableConcept type;
        @Child(name="reason", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Why should (not) substitution be made", formalDefinition="Indicates the reason for the substitution, or why substitution must or must not be performed.")
        protected CodeableConcept reason;
        private static final long serialVersionUID = 1693602518L;

        public MedicationOrderSubstitutionComponent() {
        }

        public MedicationOrderSubstitutionComponent(CodeableConcept type) {
            this.type = type;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationOrderSubstitutionComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public MedicationOrderSubstitutionComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public CodeableConcept getReason() {
            if (this.reason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationOrderSubstitutionComponent.reason");
                }
                if (Configuration.doAutoCreate()) {
                    this.reason = new CodeableConcept();
                }
            }
            return this.reason;
        }

        public boolean hasReason() {
            return this.reason != null && !this.reason.isEmpty();
        }

        public MedicationOrderSubstitutionComponent setReason(CodeableConcept value) {
            this.reason = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "CodeableConcept", "A code signifying whether a different drug should be dispensed from what was prescribed.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("reason", "CodeableConcept", "Indicates the reason for the substitution, or why substitution must or must not be performed.", 0, Integer.MAX_VALUE, this.reason));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("reason")) {
                this.reason = this.castToCodeableConcept(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("reason")) {
                this.reason = new CodeableConcept();
                return this.reason;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationOrderSubstitutionComponent copy() {
            MedicationOrderSubstitutionComponent dst = new MedicationOrderSubstitutionComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.reason = this.reason == null ? null : this.reason.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof MedicationOrderSubstitutionComponent)) {
                return false;
            }
            MedicationOrderSubstitutionComponent o = (MedicationOrderSubstitutionComponent)other;
            return MedicationOrderSubstitutionComponent.compareDeep(this.type, o.type, true) && MedicationOrderSubstitutionComponent.compareDeep(this.reason, o.reason, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof MedicationOrderSubstitutionComponent)) {
                return false;
            }
            MedicationOrderSubstitutionComponent o = (MedicationOrderSubstitutionComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.reason != null && !this.reason.isEmpty());
        }

        @Override
        public String fhirType() {
            return "MedicationOrder.substitution";
        }
    }

    @Block
    public static class MedicationOrderDispenseRequestComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="medication", type={CodeableConcept.class, Medication.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Product to be supplied", formalDefinition="Identifies the medication being administered. This is a link to a resource that represents the medication which may be the details of the medication or simply an attribute carrying a code that identifies the medication from a known list of medications.")
        protected Type medication;
        @Child(name="validityPeriod", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Time period supply is authorized for", formalDefinition="This indicates the validity period of a prescription (stale dating the Prescription).")
        protected Period validityPeriod;
        @Child(name="numberOfRepeatsAllowed", type={PositiveIntType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Number of refills authorized", formalDefinition="An integer indicating the number of additional times (aka refills or repeats) the patient can receive the prescribed medication.   Usage Notes: This integer does NOT include the original order dispense.   This means that if an order indicates dispense 30 tablets plus  \"3 repeats\", then the order can be dispensed a total of 4 times and the patient can receive a total of 120 tablets.")
        protected PositiveIntType numberOfRepeatsAllowed;
        @Child(name="quantity", type={SimpleQuantity.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Amount of medication to supply per dispense", formalDefinition="The amount that is to be dispensed for one fill.")
        protected SimpleQuantity quantity;
        @Child(name="expectedSupplyDuration", type={Duration.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Number of days supply per dispense", formalDefinition="Identifies the period time over which the supplied product is expected to be used, or the length of time the dispense is expected to last.")
        protected Duration expectedSupplyDuration;
        private static final long serialVersionUID = -1690502728L;

        public Type getMedication() {
            return this.medication;
        }

        public CodeableConcept getMedicationCodeableConcept() throws FHIRException {
            if (!(this.medication instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.medication.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.medication;
        }

        public boolean hasMedicationCodeableConcept() {
            return this.medication instanceof CodeableConcept;
        }

        public Reference getMedicationReference() throws FHIRException {
            if (!(this.medication instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.medication.getClass().getName() + " was encountered");
            }
            return (Reference)this.medication;
        }

        public boolean hasMedicationReference() {
            return this.medication instanceof Reference;
        }

        public boolean hasMedication() {
            return this.medication != null && !this.medication.isEmpty();
        }

        public MedicationOrderDispenseRequestComponent setMedication(Type value) {
            this.medication = value;
            return this;
        }

        public Period getValidityPeriod() {
            if (this.validityPeriod == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationOrderDispenseRequestComponent.validityPeriod");
                }
                if (Configuration.doAutoCreate()) {
                    this.validityPeriod = new Period();
                }
            }
            return this.validityPeriod;
        }

        public boolean hasValidityPeriod() {
            return this.validityPeriod != null && !this.validityPeriod.isEmpty();
        }

        public MedicationOrderDispenseRequestComponent setValidityPeriod(Period value) {
            this.validityPeriod = value;
            return this;
        }

        public PositiveIntType getNumberOfRepeatsAllowedElement() {
            if (this.numberOfRepeatsAllowed == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationOrderDispenseRequestComponent.numberOfRepeatsAllowed");
                }
                if (Configuration.doAutoCreate()) {
                    this.numberOfRepeatsAllowed = new PositiveIntType();
                }
            }
            return this.numberOfRepeatsAllowed;
        }

        public boolean hasNumberOfRepeatsAllowedElement() {
            return this.numberOfRepeatsAllowed != null && !this.numberOfRepeatsAllowed.isEmpty();
        }

        public boolean hasNumberOfRepeatsAllowed() {
            return this.numberOfRepeatsAllowed != null && !this.numberOfRepeatsAllowed.isEmpty();
        }

        public MedicationOrderDispenseRequestComponent setNumberOfRepeatsAllowedElement(PositiveIntType value) {
            this.numberOfRepeatsAllowed = value;
            return this;
        }

        public int getNumberOfRepeatsAllowed() {
            return this.numberOfRepeatsAllowed == null || this.numberOfRepeatsAllowed.isEmpty() ? 0 : (Integer)this.numberOfRepeatsAllowed.getValue();
        }

        public MedicationOrderDispenseRequestComponent setNumberOfRepeatsAllowed(int value) {
            if (this.numberOfRepeatsAllowed == null) {
                this.numberOfRepeatsAllowed = new PositiveIntType();
            }
            this.numberOfRepeatsAllowed.setValue((Object)value);
            return this;
        }

        public SimpleQuantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationOrderDispenseRequestComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new SimpleQuantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public MedicationOrderDispenseRequestComponent setQuantity(SimpleQuantity value) {
            this.quantity = value;
            return this;
        }

        public Duration getExpectedSupplyDuration() {
            if (this.expectedSupplyDuration == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationOrderDispenseRequestComponent.expectedSupplyDuration");
                }
                if (Configuration.doAutoCreate()) {
                    this.expectedSupplyDuration = new Duration();
                }
            }
            return this.expectedSupplyDuration;
        }

        public boolean hasExpectedSupplyDuration() {
            return this.expectedSupplyDuration != null && !this.expectedSupplyDuration.isEmpty();
        }

        public MedicationOrderDispenseRequestComponent setExpectedSupplyDuration(Duration value) {
            this.expectedSupplyDuration = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("medication[x]", "CodeableConcept|Reference(Medication)", "Identifies the medication being administered. This is a link to a resource that represents the medication which may be the details of the medication or simply an attribute carrying a code that identifies the medication from a known list of medications.", 0, Integer.MAX_VALUE, this.medication));
            childrenList.add(new Property("validityPeriod", "Period", "This indicates the validity period of a prescription (stale dating the Prescription).", 0, Integer.MAX_VALUE, this.validityPeriod));
            childrenList.add(new Property("numberOfRepeatsAllowed", "positiveInt", "An integer indicating the number of additional times (aka refills or repeats) the patient can receive the prescribed medication.   Usage Notes: This integer does NOT include the original order dispense.   This means that if an order indicates dispense 30 tablets plus  \"3 repeats\", then the order can be dispensed a total of 4 times and the patient can receive a total of 120 tablets.", 0, Integer.MAX_VALUE, this.numberOfRepeatsAllowed));
            childrenList.add(new Property("quantity", "SimpleQuantity", "The amount that is to be dispensed for one fill.", 0, Integer.MAX_VALUE, this.quantity));
            childrenList.add(new Property("expectedSupplyDuration", "Duration", "Identifies the period time over which the supplied product is expected to be used, or the length of time the dispense is expected to last.", 0, Integer.MAX_VALUE, this.expectedSupplyDuration));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("medication[x]")) {
                this.medication = (Type)value;
            } else if (name.equals("validityPeriod")) {
                this.validityPeriod = this.castToPeriod(value);
            } else if (name.equals("numberOfRepeatsAllowed")) {
                this.numberOfRepeatsAllowed = this.castToPositiveInt(value);
            } else if (name.equals("quantity")) {
                this.quantity = this.castToSimpleQuantity(value);
            } else if (name.equals("expectedSupplyDuration")) {
                this.expectedSupplyDuration = this.castToDuration(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("medicationCodeableConcept")) {
                this.medication = new CodeableConcept();
                return this.medication;
            }
            if (name.equals("medicationReference")) {
                this.medication = new Reference();
                return this.medication;
            }
            if (name.equals("validityPeriod")) {
                this.validityPeriod = new Period();
                return this.validityPeriod;
            }
            if (name.equals("numberOfRepeatsAllowed")) {
                throw new FHIRException("Cannot call addChild on a primitive type MedicationOrder.numberOfRepeatsAllowed");
            }
            if (name.equals("quantity")) {
                this.quantity = new SimpleQuantity();
                return this.quantity;
            }
            if (name.equals("expectedSupplyDuration")) {
                this.expectedSupplyDuration = new Duration();
                return this.expectedSupplyDuration;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationOrderDispenseRequestComponent copy() {
            MedicationOrderDispenseRequestComponent dst = new MedicationOrderDispenseRequestComponent();
            this.copyValues(dst);
            dst.medication = this.medication == null ? null : this.medication.copy();
            dst.validityPeriod = this.validityPeriod == null ? null : this.validityPeriod.copy();
            dst.numberOfRepeatsAllowed = this.numberOfRepeatsAllowed == null ? null : this.numberOfRepeatsAllowed.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.expectedSupplyDuration = this.expectedSupplyDuration == null ? null : this.expectedSupplyDuration.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof MedicationOrderDispenseRequestComponent)) {
                return false;
            }
            MedicationOrderDispenseRequestComponent o = (MedicationOrderDispenseRequestComponent)other;
            return MedicationOrderDispenseRequestComponent.compareDeep(this.medication, o.medication, true) && MedicationOrderDispenseRequestComponent.compareDeep(this.validityPeriod, o.validityPeriod, true) && MedicationOrderDispenseRequestComponent.compareDeep(this.numberOfRepeatsAllowed, o.numberOfRepeatsAllowed, true) && MedicationOrderDispenseRequestComponent.compareDeep(this.quantity, o.quantity, true) && MedicationOrderDispenseRequestComponent.compareDeep(this.expectedSupplyDuration, o.expectedSupplyDuration, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof MedicationOrderDispenseRequestComponent)) {
                return false;
            }
            MedicationOrderDispenseRequestComponent o = (MedicationOrderDispenseRequestComponent)other;
            return MedicationOrderDispenseRequestComponent.compareValues(this.numberOfRepeatsAllowed, o.numberOfRepeatsAllowed, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.medication != null && !this.medication.isEmpty() || this.validityPeriod != null && !this.validityPeriod.isEmpty() || this.numberOfRepeatsAllowed != null && !this.numberOfRepeatsAllowed.isEmpty() || this.quantity != null && !this.quantity.isEmpty() || this.expectedSupplyDuration != null && !this.expectedSupplyDuration.isEmpty());
        }

        @Override
        public String fhirType() {
            return "MedicationOrder.dispenseRequest";
        }
    }

    @Block
    public static class MedicationOrderDosageInstructionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="text", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Dosage instructions expressed as text", formalDefinition="Free text dosage instructions can be used for cases where the instructions are too complex to code.  The content of this attribute does not include the name or description of the medication. When coded instructions are present, the free text instructions may still be present for display to humans taking or administering the medication. It is expected that the text instructions will always be populated.  If the dosage.timing attribute is also populated, then the dosage.text should reflect the same information as the timing.")
        protected StringType text;
        @Child(name="additionalInstructions", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Supplemental instructions - e.g. \"with meals\"", formalDefinition="Additional instructions such as \"Swallow with plenty of water\" which may or may not be coded.")
        protected CodeableConcept additionalInstructions;
        @Child(name="timing", type={Timing.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="When medication should be administered", formalDefinition="The timing schedule for giving the medication to the patient. The Schedule data type allows many different expressions. For example: \"Every 8 hours\"; \"Three times a day\"; \"1/2 an hour before breakfast for 10 days from 23-Dec 2011:\"; \"15 Oct 2013, 17 Oct 2013 and 1 Nov 2013\".")
        protected Timing timing;
        @Child(name="asNeeded", type={BooleanType.class, CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Take \"as needed\" (for x)", formalDefinition="Indicates whether the Medication is only taken when needed within a specific dosing schedule (Boolean option), or it indicates the precondition for taking the Medication (CodeableConcept).")
        protected Type asNeeded;
        @Child(name="site", type={CodeableConcept.class, BodySite.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Body site to administer to", formalDefinition="A coded specification of the anatomic site where the medication first enters the body.")
        protected Type site;
        @Child(name="route", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="How drug should enter body", formalDefinition="A code specifying the route or physiological path of administration of a therapeutic agent into or onto a patient's body.")
        protected CodeableConcept route;
        @Child(name="method", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Technique for administering medication", formalDefinition="A coded value indicating the method by which the medication is introduced into or onto the body. Most commonly used for injections.  For examples, Slow Push; Deep IV.")
        protected CodeableConcept method;
        @Child(name="dose", type={Range.class, SimpleQuantity.class}, order=8, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Amount of medication per dose", formalDefinition="The amount of therapeutic or other substance given at one administration event.")
        protected Type dose;
        @Child(name="rate", type={Ratio.class, Range.class}, order=9, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Amount of medication per unit of time", formalDefinition="Identifies the speed with which the medication was or will be introduced into the patient. Typically the rate for an infusion e.g. 100 ml per 1 hour or 100 ml/hr.  May also be expressed as a rate per unit of time e.g. 500 ml per 2 hours.   Currently we do not specify a default of '1' in the denominator, but this is being discussed. Other examples: 200 mcg/min or 200 mcg/1 minute; 1 liter/8 hours.")
        protected Type rate;
        @Child(name="maxDosePerPeriod", type={Ratio.class}, order=10, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Upper limit on medication per unit of time", formalDefinition="The maximum total quantity of a therapeutic substance that may be administered to a subject over the period of time.  For example, 1000mg in 24 hours.")
        protected Ratio maxDosePerPeriod;
        private static final long serialVersionUID = -1470136646L;

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationOrderDosageInstructionComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public MedicationOrderDosageInstructionComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public MedicationOrderDosageInstructionComponent setText(String value) {
            if (Utilities.noString((String)value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        public CodeableConcept getAdditionalInstructions() {
            if (this.additionalInstructions == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationOrderDosageInstructionComponent.additionalInstructions");
                }
                if (Configuration.doAutoCreate()) {
                    this.additionalInstructions = new CodeableConcept();
                }
            }
            return this.additionalInstructions;
        }

        public boolean hasAdditionalInstructions() {
            return this.additionalInstructions != null && !this.additionalInstructions.isEmpty();
        }

        public MedicationOrderDosageInstructionComponent setAdditionalInstructions(CodeableConcept value) {
            this.additionalInstructions = value;
            return this;
        }

        public Timing getTiming() {
            if (this.timing == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationOrderDosageInstructionComponent.timing");
                }
                if (Configuration.doAutoCreate()) {
                    this.timing = new Timing();
                }
            }
            return this.timing;
        }

        public boolean hasTiming() {
            return this.timing != null && !this.timing.isEmpty();
        }

        public MedicationOrderDosageInstructionComponent setTiming(Timing value) {
            this.timing = value;
            return this;
        }

        public Type getAsNeeded() {
            return this.asNeeded;
        }

        public BooleanType getAsNeededBooleanType() throws FHIRException {
            if (!(this.asNeeded instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.asNeeded.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.asNeeded;
        }

        public boolean hasAsNeededBooleanType() {
            return this.asNeeded instanceof BooleanType;
        }

        public CodeableConcept getAsNeededCodeableConcept() throws FHIRException {
            if (!(this.asNeeded instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.asNeeded.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.asNeeded;
        }

        public boolean hasAsNeededCodeableConcept() {
            return this.asNeeded instanceof CodeableConcept;
        }

        public boolean hasAsNeeded() {
            return this.asNeeded != null && !this.asNeeded.isEmpty();
        }

        public MedicationOrderDosageInstructionComponent setAsNeeded(Type value) {
            this.asNeeded = value;
            return this;
        }

        public Type getSite() {
            return this.site;
        }

        public CodeableConcept getSiteCodeableConcept() throws FHIRException {
            if (!(this.site instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.site.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.site;
        }

        public boolean hasSiteCodeableConcept() {
            return this.site instanceof CodeableConcept;
        }

        public Reference getSiteReference() throws FHIRException {
            if (!(this.site instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.site.getClass().getName() + " was encountered");
            }
            return (Reference)this.site;
        }

        public boolean hasSiteReference() {
            return this.site instanceof Reference;
        }

        public boolean hasSite() {
            return this.site != null && !this.site.isEmpty();
        }

        public MedicationOrderDosageInstructionComponent setSite(Type value) {
            this.site = value;
            return this;
        }

        public CodeableConcept getRoute() {
            if (this.route == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationOrderDosageInstructionComponent.route");
                }
                if (Configuration.doAutoCreate()) {
                    this.route = new CodeableConcept();
                }
            }
            return this.route;
        }

        public boolean hasRoute() {
            return this.route != null && !this.route.isEmpty();
        }

        public MedicationOrderDosageInstructionComponent setRoute(CodeableConcept value) {
            this.route = value;
            return this;
        }

        public CodeableConcept getMethod() {
            if (this.method == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationOrderDosageInstructionComponent.method");
                }
                if (Configuration.doAutoCreate()) {
                    this.method = new CodeableConcept();
                }
            }
            return this.method;
        }

        public boolean hasMethod() {
            return this.method != null && !this.method.isEmpty();
        }

        public MedicationOrderDosageInstructionComponent setMethod(CodeableConcept value) {
            this.method = value;
            return this;
        }

        public Type getDose() {
            return this.dose;
        }

        public Range getDoseRange() throws FHIRException {
            if (!(this.dose instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.dose.getClass().getName() + " was encountered");
            }
            return (Range)this.dose;
        }

        public boolean hasDoseRange() {
            return this.dose instanceof Range;
        }

        public SimpleQuantity getDoseSimpleQuantity() throws FHIRException {
            if (!(this.dose instanceof SimpleQuantity)) {
                throw new FHIRException("Type mismatch: the type SimpleQuantity was expected, but " + this.dose.getClass().getName() + " was encountered");
            }
            return (SimpleQuantity)this.dose;
        }

        public boolean hasDoseSimpleQuantity() {
            return this.dose instanceof SimpleQuantity;
        }

        public boolean hasDose() {
            return this.dose != null && !this.dose.isEmpty();
        }

        public MedicationOrderDosageInstructionComponent setDose(Type value) {
            this.dose = value;
            return this;
        }

        public Type getRate() {
            return this.rate;
        }

        public Ratio getRateRatio() throws FHIRException {
            if (!(this.rate instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.rate.getClass().getName() + " was encountered");
            }
            return (Ratio)this.rate;
        }

        public boolean hasRateRatio() {
            return this.rate instanceof Ratio;
        }

        public Range getRateRange() throws FHIRException {
            if (!(this.rate instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.rate.getClass().getName() + " was encountered");
            }
            return (Range)this.rate;
        }

        public boolean hasRateRange() {
            return this.rate instanceof Range;
        }

        public boolean hasRate() {
            return this.rate != null && !this.rate.isEmpty();
        }

        public MedicationOrderDosageInstructionComponent setRate(Type value) {
            this.rate = value;
            return this;
        }

        public Ratio getMaxDosePerPeriod() {
            if (this.maxDosePerPeriod == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicationOrderDosageInstructionComponent.maxDosePerPeriod");
                }
                if (Configuration.doAutoCreate()) {
                    this.maxDosePerPeriod = new Ratio();
                }
            }
            return this.maxDosePerPeriod;
        }

        public boolean hasMaxDosePerPeriod() {
            return this.maxDosePerPeriod != null && !this.maxDosePerPeriod.isEmpty();
        }

        public MedicationOrderDosageInstructionComponent setMaxDosePerPeriod(Ratio value) {
            this.maxDosePerPeriod = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("text", "string", "Free text dosage instructions can be used for cases where the instructions are too complex to code.  The content of this attribute does not include the name or description of the medication. When coded instructions are present, the free text instructions may still be present for display to humans taking or administering the medication. It is expected that the text instructions will always be populated.  If the dosage.timing attribute is also populated, then the dosage.text should reflect the same information as the timing.", 0, Integer.MAX_VALUE, this.text));
            childrenList.add(new Property("additionalInstructions", "CodeableConcept", "Additional instructions such as \"Swallow with plenty of water\" which may or may not be coded.", 0, Integer.MAX_VALUE, this.additionalInstructions));
            childrenList.add(new Property("timing", "Timing", "The timing schedule for giving the medication to the patient. The Schedule data type allows many different expressions. For example: \"Every 8 hours\"; \"Three times a day\"; \"1/2 an hour before breakfast for 10 days from 23-Dec 2011:\"; \"15 Oct 2013, 17 Oct 2013 and 1 Nov 2013\".", 0, Integer.MAX_VALUE, this.timing));
            childrenList.add(new Property("asNeeded[x]", "boolean|CodeableConcept", "Indicates whether the Medication is only taken when needed within a specific dosing schedule (Boolean option), or it indicates the precondition for taking the Medication (CodeableConcept).", 0, Integer.MAX_VALUE, this.asNeeded));
            childrenList.add(new Property("site[x]", "CodeableConcept|Reference(BodySite)", "A coded specification of the anatomic site where the medication first enters the body.", 0, Integer.MAX_VALUE, this.site));
            childrenList.add(new Property("route", "CodeableConcept", "A code specifying the route or physiological path of administration of a therapeutic agent into or onto a patient's body.", 0, Integer.MAX_VALUE, this.route));
            childrenList.add(new Property("method", "CodeableConcept", "A coded value indicating the method by which the medication is introduced into or onto the body. Most commonly used for injections.  For examples, Slow Push; Deep IV.", 0, Integer.MAX_VALUE, this.method));
            childrenList.add(new Property("dose[x]", "Range|SimpleQuantity", "The amount of therapeutic or other substance given at one administration event.", 0, Integer.MAX_VALUE, this.dose));
            childrenList.add(new Property("rate[x]", "Ratio|Range", "Identifies the speed with which the medication was or will be introduced into the patient. Typically the rate for an infusion e.g. 100 ml per 1 hour or 100 ml/hr.  May also be expressed as a rate per unit of time e.g. 500 ml per 2 hours.   Currently we do not specify a default of '1' in the denominator, but this is being discussed. Other examples: 200 mcg/min or 200 mcg/1 minute; 1 liter/8 hours.", 0, Integer.MAX_VALUE, this.rate));
            childrenList.add(new Property("maxDosePerPeriod", "Ratio", "The maximum total quantity of a therapeutic substance that may be administered to a subject over the period of time.  For example, 1000mg in 24 hours.", 0, Integer.MAX_VALUE, this.maxDosePerPeriod));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("text")) {
                this.text = this.castToString(value);
            } else if (name.equals("additionalInstructions")) {
                this.additionalInstructions = this.castToCodeableConcept(value);
            } else if (name.equals("timing")) {
                this.timing = this.castToTiming(value);
            } else if (name.equals("asNeeded[x]")) {
                this.asNeeded = (Type)value;
            } else if (name.equals("site[x]")) {
                this.site = (Type)value;
            } else if (name.equals("route")) {
                this.route = this.castToCodeableConcept(value);
            } else if (name.equals("method")) {
                this.method = this.castToCodeableConcept(value);
            } else if (name.equals("dose[x]")) {
                this.dose = (Type)value;
            } else if (name.equals("rate[x]")) {
                this.rate = (Type)value;
            } else if (name.equals("maxDosePerPeriod")) {
                this.maxDosePerPeriod = this.castToRatio(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a primitive type MedicationOrder.text");
            }
            if (name.equals("additionalInstructions")) {
                this.additionalInstructions = new CodeableConcept();
                return this.additionalInstructions;
            }
            if (name.equals("timing")) {
                this.timing = new Timing();
                return this.timing;
            }
            if (name.equals("asNeededBoolean")) {
                this.asNeeded = new BooleanType();
                return this.asNeeded;
            }
            if (name.equals("asNeededCodeableConcept")) {
                this.asNeeded = new CodeableConcept();
                return this.asNeeded;
            }
            if (name.equals("siteCodeableConcept")) {
                this.site = new CodeableConcept();
                return this.site;
            }
            if (name.equals("siteReference")) {
                this.site = new Reference();
                return this.site;
            }
            if (name.equals("route")) {
                this.route = new CodeableConcept();
                return this.route;
            }
            if (name.equals("method")) {
                this.method = new CodeableConcept();
                return this.method;
            }
            if (name.equals("doseRange")) {
                this.dose = new Range();
                return this.dose;
            }
            if (name.equals("doseSimpleQuantity")) {
                this.dose = new SimpleQuantity();
                return this.dose;
            }
            if (name.equals("rateRatio")) {
                this.rate = new Ratio();
                return this.rate;
            }
            if (name.equals("rateRange")) {
                this.rate = new Range();
                return this.rate;
            }
            if (name.equals("maxDosePerPeriod")) {
                this.maxDosePerPeriod = new Ratio();
                return this.maxDosePerPeriod;
            }
            return super.addChild(name);
        }

        @Override
        public MedicationOrderDosageInstructionComponent copy() {
            MedicationOrderDosageInstructionComponent dst = new MedicationOrderDosageInstructionComponent();
            this.copyValues(dst);
            dst.text = this.text == null ? null : this.text.copy();
            dst.additionalInstructions = this.additionalInstructions == null ? null : this.additionalInstructions.copy();
            dst.timing = this.timing == null ? null : this.timing.copy();
            dst.asNeeded = this.asNeeded == null ? null : this.asNeeded.copy();
            dst.site = this.site == null ? null : this.site.copy();
            dst.route = this.route == null ? null : this.route.copy();
            dst.method = this.method == null ? null : this.method.copy();
            dst.dose = this.dose == null ? null : this.dose.copy();
            dst.rate = this.rate == null ? null : this.rate.copy();
            dst.maxDosePerPeriod = this.maxDosePerPeriod == null ? null : this.maxDosePerPeriod.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof MedicationOrderDosageInstructionComponent)) {
                return false;
            }
            MedicationOrderDosageInstructionComponent o = (MedicationOrderDosageInstructionComponent)other;
            return MedicationOrderDosageInstructionComponent.compareDeep(this.text, o.text, true) && MedicationOrderDosageInstructionComponent.compareDeep(this.additionalInstructions, o.additionalInstructions, true) && MedicationOrderDosageInstructionComponent.compareDeep(this.timing, o.timing, true) && MedicationOrderDosageInstructionComponent.compareDeep(this.asNeeded, o.asNeeded, true) && MedicationOrderDosageInstructionComponent.compareDeep(this.site, o.site, true) && MedicationOrderDosageInstructionComponent.compareDeep(this.route, o.route, true) && MedicationOrderDosageInstructionComponent.compareDeep(this.method, o.method, true) && MedicationOrderDosageInstructionComponent.compareDeep(this.dose, o.dose, true) && MedicationOrderDosageInstructionComponent.compareDeep(this.rate, o.rate, true) && MedicationOrderDosageInstructionComponent.compareDeep(this.maxDosePerPeriod, o.maxDosePerPeriod, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof MedicationOrderDosageInstructionComponent)) {
                return false;
            }
            MedicationOrderDosageInstructionComponent o = (MedicationOrderDosageInstructionComponent)other;
            return MedicationOrderDosageInstructionComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.text != null && !this.text.isEmpty() || this.additionalInstructions != null && !this.additionalInstructions.isEmpty() || this.timing != null && !this.timing.isEmpty() || this.asNeeded != null && !this.asNeeded.isEmpty() || this.site != null && !this.site.isEmpty() || this.route != null && !this.route.isEmpty() || this.method != null && !this.method.isEmpty() || this.dose != null && !this.dose.isEmpty() || this.rate != null && !this.rate.isEmpty() || this.maxDosePerPeriod != null && !this.maxDosePerPeriod.isEmpty());
        }

        @Override
        public String fhirType() {
            return "MedicationOrder.dosageInstruction";
        }
    }

    public static class MedicationOrderStatusEnumFactory
    implements EnumFactory<MedicationOrderStatus> {
        @Override
        public MedicationOrderStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return MedicationOrderStatus.ACTIVE;
            }
            if ("on-hold".equals(codeString)) {
                return MedicationOrderStatus.ONHOLD;
            }
            if ("completed".equals(codeString)) {
                return MedicationOrderStatus.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return MedicationOrderStatus.ENTEREDINERROR;
            }
            if ("stopped".equals(codeString)) {
                return MedicationOrderStatus.STOPPED;
            }
            if ("draft".equals(codeString)) {
                return MedicationOrderStatus.DRAFT;
            }
            throw new IllegalArgumentException("Unknown MedicationOrderStatus code '" + codeString + "'");
        }

        public Enumeration<MedicationOrderStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<MedicationOrderStatus>(this, MedicationOrderStatus.ACTIVE);
            }
            if ("on-hold".equals(codeString)) {
                return new Enumeration<MedicationOrderStatus>(this, MedicationOrderStatus.ONHOLD);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<MedicationOrderStatus>(this, MedicationOrderStatus.COMPLETED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<MedicationOrderStatus>(this, MedicationOrderStatus.ENTEREDINERROR);
            }
            if ("stopped".equals(codeString)) {
                return new Enumeration<MedicationOrderStatus>(this, MedicationOrderStatus.STOPPED);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<MedicationOrderStatus>(this, MedicationOrderStatus.DRAFT);
            }
            throw new FHIRException("Unknown MedicationOrderStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(MedicationOrderStatus code) {
            if (code == MedicationOrderStatus.ACTIVE) {
                return "active";
            }
            if (code == MedicationOrderStatus.ONHOLD) {
                return "on-hold";
            }
            if (code == MedicationOrderStatus.COMPLETED) {
                return "completed";
            }
            if (code == MedicationOrderStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == MedicationOrderStatus.STOPPED) {
                return "stopped";
            }
            if (code == MedicationOrderStatus.DRAFT) {
                return "draft";
            }
            return "?";
        }
    }

    public static enum MedicationOrderStatus {
        ACTIVE,
        ONHOLD,
        COMPLETED,
        ENTEREDINERROR,
        STOPPED,
        DRAFT,
        NULL;


        public static MedicationOrderStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("on-hold".equals(codeString)) {
                return ONHOLD;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("stopped".equals(codeString)) {
                return STOPPED;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            throw new FHIRException("Unknown MedicationOrderStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case ONHOLD: {
                    return "on-hold";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case STOPPED: {
                    return "stopped";
                }
                case DRAFT: {
                    return "draft";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/medication-order-status";
                }
                case ONHOLD: {
                    return "http://hl7.org/fhir/medication-order-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/medication-order-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/medication-order-status";
                }
                case STOPPED: {
                    return "http://hl7.org/fhir/medication-order-status";
                }
                case DRAFT: {
                    return "http://hl7.org/fhir/medication-order-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The prescription is 'actionable', but not all actions that are implied by it have occurred yet.";
                }
                case ONHOLD: {
                    return "Actions implied by the prescription are to be temporarily halted, but are expected to continue later.  May also be called \"suspended\".";
                }
                case COMPLETED: {
                    return "All actions that are implied by the prescription have occurred.";
                }
                case ENTEREDINERROR: {
                    return "The prescription was entered in error.";
                }
                case STOPPED: {
                    return "Actions implied by the prescription are to be permanently halted, before all of them occurred.";
                }
                case DRAFT: {
                    return "The prescription is not yet 'actionable', i.e. it is a work in progress, requires sign-off or verification, and needs to be run through decision support process.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case ONHOLD: {
                    return "On Hold";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered In Error";
                }
                case STOPPED: {
                    return "Stopped";
                }
                case DRAFT: {
                    return "Draft";
                }
            }
            return "?";
        }
    }
}

