/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import java.util.Date;
import java.util.TimeZone;
import org.hl7.fhir.instance.model.BaseDateTimeType;
import org.hl7.fhir.instance.model.InstantType;
import org.hl7.fhir.instance.model.TemporalPrecisionEnum;

@DatatypeDef(name="date")
public class DateType
extends BaseDateTimeType {
    private static final long serialVersionUID = 3L;
    public static final TemporalPrecisionEnum DEFAULT_PRECISION = TemporalPrecisionEnum.DAY;

    public DateType() {
    }

    public DateType(Date theDate) {
        super(theDate, DEFAULT_PRECISION);
    }

    public DateType(Date theDate, TemporalPrecisionEnum thePrecision) {
        super(theDate, thePrecision);
    }

    public DateType(String theDate) {
        super(theDate);
    }

    @Override
    boolean isPrecisionAllowed(TemporalPrecisionEnum thePrecision) {
        switch (thePrecision) {
            case YEAR: 
            case MONTH: 
            case DAY: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected TemporalPrecisionEnum getDefaultPrecisionForDatatype() {
        return DEFAULT_PRECISION;
    }

    @Override
    public DateType copy() {
        return new DateType((Date)this.getValue());
    }

    public static InstantType today() {
        return new InstantType(new Date(), TemporalPrecisionEnum.DAY, TimeZone.getDefault());
    }

    public static DateType parseV3(String theV3String) {
        DateType retVal = new DateType();
        retVal.setValueAsV3String(theV3String);
        return retVal;
    }

    @Override
    public String fhirType() {
        return "date";
    }
}

